:userdoc.
:title.RexxUtil Library Reference

.******************************************************************************
:h1 x=left y=bottom width=100% height=100%.About RexxUtil
:p.RexxUtil (REXXUTIL.DLL) is a IBM library of REXX functions for interacting
with the operating system.  It is available, with minor differences, on most
platforms where the IBM REXX interpreter is available, including OS/2, Windows,
and Linux.  This document describes the OS/2 version, and applies to OS/2 Warp
3 and all subsequent releases.

:p.RexxUtil includes routines for&colon.
:ul compact.
:li.Manipulating files and directories at the filesystem level.
:li.Manipulating classes and objects in the Workplace Shell.
:li.Performing screen input and output in OS/2 command prompts.
:li.Managing character-based input and output according to locale-specific
rules.
:li.Accessing selected operating system functions for process management.
:li.Manipulating REXX stem variables.
:eul.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Registering RexxUtil functions
:p.Before you can use any RexxUtil function, you must first register it using
the REXX API function :hp9.RxFuncAdd:ehp9..

:p.For example, to register the :link reftype=hd refid=syscreateobject.SysCreateObject:elink.
function&colon.
:xmp.   CALL RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
:exmp.

:p.You can use the special RexxUtil function
:link reftype=hd refid=sysloadfuncs.SysLoadFuncs:elink. to automatically
register all RexxUtil functions.  (You must register SysLoadFuncs
separately first.)  For example&colon.
:xmp.
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
:exmp.

:p.Once RexxUtil functions have been registered, they will be available to all
other OS/2 sessions, until either they are deregistered, or the system is shut
down.

:nt.You may wish to call SysLoadFuncs using a REXX script (containing the
above code) executed from your STARTUP.CMD file.  This will make RexxUtil
functions available to all OS/2 sessions.:ent.

.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Deregistering RexxUtil functions
:p.You can deregister RexxUtil functions individually using the REXX API
function :hp9.RxFuncDrop:ehp9., or all at once using the RexxUtil function
:link reftype=hd refid=sysdropfuncs.SysDropFuncs:elink..

:p.For example, the following code will deregister the
:link reftype=hd refid=syscreateobject.SysCreateObject:elink. function&colon.
:xmp.   CALL RxFuncDrop 'SysCreateObject'
:exmp.

:p.And the following code will automatically deregister all RexxUtil
functions (including SysDropFuncs)&colon.
:xmp.   CALL SysDropFuncs
:exmp.


.******************************************************************************
:h1 x=left y=bottom width=100% height=100%.Functions
:p.This chapter describes all of the functions available in the RexxUtil
library.

:p.:hp5.Basic RexxUtil functions:ehp5.
:p.The following RexxUtil functions are available in OS/2 Warp 3.0 and all
subsequent versions.
:dl compact break=fit tsize=30.
:dt.:link reftype=hd refid=rxmessagebox.RxMessageBox:elink.
:dd.Display a Presentation Manager message box.
:dt.:link reftype=hd refid=syscls.SysCls:elink.
:dd.Clear the screen.
:dt.:link reftype=hd refid=syscopyobject.SysCopyObject:elink.
:dd.Copy a WPS object.
:dt.:link reftype=hd refid=syscreateobject.SysCreateObject:elink.
:dd.Create an instance of a WPS class.
:dt.:link reftype=hd refid=syscreateshadow.SysCreateShadow:elink.
:dd.Create a shadow of a WPS object.
:dt.:link reftype=hd refid=syscurpos.SysCurPos:elink.
:dd.Change and/or query the current cursor position within a VIO session.
:dt.:link reftype=hd refid=syscurstate.SysCurState:elink.
:dd.Display or hide the cursor within a VIO session.
:dt.:link reftype=hd refid=sysderegisterobjectclass.SysDeregisterObjectClass:elink.
:dd.Deregister a WPS class.
:dt.:link reftype=hd refid=sysdestroyobject.SysDestroyObject:elink.
:dd.Delete a WPS object.
:dt.:link reftype=hd refid=sysdriveinfo.SysDriveInfo:elink.
:dd.Return information about a disk (volume).
:dt.:link reftype=hd refid=sysdrivemap.SysDriveMap:elink.
:dd.Query the list of available drive letters.
:dt.:link reftype=hd refid=sysdropfuncs.SysDropFuncs:elink.
:dd.Unload all RexxUtil functions.
:dt.:link reftype=hd refid=sysfiledelete.SysFileDelete:elink.
:dd.Delete a file.
:dt.:link reftype=hd refid=sysfilesearch.SysFileSearch:elink.
:dd.Search for a string within a file.
:dt.:link reftype=hd refid=sysfiletree.SysFileTree:elink.
:dd.Find files with the specified criteria, and optionally change file attributes.
:dt.:link reftype=hd refid=sysgetea.SysGetEA:elink.
:dd.Read an extended attribute of a file.
:dt.:link reftype=hd refid=sysgetkey.SysGetKey:elink.
:dd.Read the next key pressed.
:dt.:link reftype=hd refid=sysgetmessage.SysGetMessage:elink.
:dd.Retrieve a message string from a message file.
:dt.:link reftype=hd refid=sysini.SysIni:elink.
:dd.Manipulate OS/2 INI files.
:dt.:link reftype=hd refid=sysmkdir.SysMkDir:elink.
:dd.Create a directory.
:dt.:link reftype=hd refid=sysmoveobject.SysMoveObject:elink.
:dd.Move a WPS object.
:dt.:link reftype=hd refid=sysopenobject.SysOpenObject:elink.
:dd.Open a WPS object.
:dt.:link reftype=hd refid=sysos2ver.SysOS2Ver:elink.
:dd.Query the OS/2 version number.
:dt.:link reftype=hd refid=sysputea.SysPutEA:elink.
:dd.Write an extended attribute to a file.
:dt.:link reftype=hd refid=sysqueryclasslist.SysQueryClassList:elink.
:dd.Query the list of registered WPS classes.
:dt.:link reftype=hd refid=sysregisterobjectclass.SysRegisterObjectClass:elink.
:dd.Register a WPS class.
:dt.:link reftype=hd refid=sysrmdir.SysRmDir:elink.
:dd.Delete a directory.
:dt.:link reftype=hd refid=syssaveobject.SysSaveObject:elink.
:dd.Save a WPS object.
:dt.:link reftype=hd refid=syssearchpath.SysSearchPath:elink.
:dd.Search a path for a file specification.
:dt.:link reftype=hd refid=sysseticon.SysSetIcon:elink.
:dd.Set an object's icon.
:dt.:link reftype=hd refid=syssetobjectdata.SysSetObjectData:elink.
:dd.Change the settings of a WPS object.
:dt.:link reftype=hd refid=syssleep.SysSleep:elink.
:dd.Pause the current thread for the specified interval.
:dt.:link reftype=hd refid=systempfilename.SysTempFileName:elink.
:dd.Generate a temporary file name.
:dt.:link reftype=hd refid=systextscreenread.SysTextScreenRead:elink.
:dd.Read characters from the screen within a VIO session.
:dt.:link reftype=hd refid=systextscreensize.SysTextScreenSize:elink.
:dd.Query the size of the screen within a VIO session.
:dt.:link reftype=hd refid=syswaitnamedpipe.SysWaitNamedPipe:elink.
:dd.Wait for a named pipe to become available.
:edl.

:p.:hp5.Additional RexxUtil functions:ehp5.
:P.The following additional functions were introduced in FixPak 35 for OS/2
Warp 3 and FixPak 6 for OS/2 Warp 4.  Many of these actually originated with
IBM Object REXX, but were subsequently added to the standard REXXUTIL library.
Others were introduced to allow access to new operating system features.
:dl compact break=fit tsize=30.
:dt.:link reftype=hd refid=sysaddfilehandle.SysAddFileHandle:elink.
:dd.Increase the number of available file handles.
:dt.:link reftype=hd refid=sysaddrexxmacro.SysAddRexxMacro:elink.
:dd.Add a function to the REXX macrospace.
:dt.:link reftype=hd refid=sysbootdrive.SysBootDrive:elink.
:dd.Return the system boot drive.
:dt.:link reftype=hd refid=sysclearrexxmacrospace.SysClearRexxMacroSpace:elink.
:dd.Clear the REXX macrospace.
:dt.:link reftype=hd refid=syscloseeventsem.SysCloseEventSem:elink.
:dd.Close an event semaphore.
:dt.:link reftype=hd refid=sysclosemutexsem.SysCloseMutexSem:elink.
:dd.Close a mutex semaphore.
:dt.:link reftype=hd refid=syscreateeventsem.SysCreateEventSem:elink.
:dd.Create an event semaphore
:dt.:link reftype=hd refid=syscreatemutexsem.SysCreateMutexSem:elink.
:dd.Create a mutex semaphore.
:dt.:link reftype=hd refid=sysdroprexxmacro.SysDropRexxMacro:elink.
:dd.Remove a function from the REXX macrospace.
:dt.:link reftype=hd refid=sysdumpvariables.SysDumpVariables:elink.
:dd.Dump all variables in the current scope either to a file or to STDOUT.
:dt.:link reftype=hd refid=syselapsedtime.SysElapsedTime:elink.
:dd.Query and/or reset the high-resolution timer.
:dt.:link reftype=hd refid=sysfilesystemtype.SysFileSystemType:elink.
:dd.Query the filesystem of the specified volume.
:dt.:link reftype=hd refid=sysgetcollate.SysGetCollate:elink.
:dd.Return the collating sequence table for the specified country/codepage combination.
:dt.:link reftype=hd refid=sysgetfiledatetime.SysGetFileDateTime:elink.
:dd.Return a file's date/time attribute.
:dt.:link reftype=hd refid=sysloadrexxmacrospace.SysLoadRexxMacroSpace:elink.
:dd.Load saved macrospace functions from a file.
:dt.:link reftype=hd refid=sysmapcase.SysMapCase:elink.
:dd.Convert a string to uppercase according to localization rules.
:dt.:link reftype=hd refid=sysnationallanguagecompare.SysNationalLanguageCompare:elink.
:dd.Compare two strings according to the specified collating table.
:dt.:link reftype=hd refid=sysopeneventsem.SysOpenEventSem:elink.
:dd.Open the specified event semaphore.
:dt.:link reftype=hd refid=sysopenmutexsem.SysOpenMutexSem:elink.
:dd.Open the specified mutex semaphore.
:dt.:link reftype=hd refid=sysposteventsem.SysPostEventSem:elink.
:dd.Post the specified event semaphore.
:dt.:link reftype=hd refid=sysprocesstype.SysProcessType:elink.
:dd.Return the process type of the currently-running REXX program.
:dt.:link reftype=hd refid=sysqueryealist.SysQueryEAList:elink.
:dd.Query the list of extended attribute names associated with a file.
:dt.:link reftype=hd refid=sysqueryextlibpath.SysQueryExtLIBPATH:elink.
:dd.Return the current value of the extended LIBPATH.
:dt.:link reftype=hd refid=sysqueryprocesscodepage.SysQueryProcessCodePage:elink.
:dd.Query the codepage being used by the current process.
:dt.:link reftype=hd refid=sysqueryrexxmacro.SysQueryRexxMacro:elink.
:dd.Check for a routine in the REXX macrospace.
:dt.:link reftype=hd refid=sysqueryswitchlist.SysQuerySwitchList:elink.
:dd.Query the contents of the window list.
:dt.:link reftype=hd refid=sysreleasemutexsem.SysReleaseMutexSem:elink.
:dd.Release the specified mutex semaphore.
:dt.:link reftype=hd refid=sysreorderrexxmacro.SysReorderRexxMacro:elink.
:dd.Change the search order of a macrospace function.
:dt.:link reftype=hd refid=sysrequestmutexsem.SysRequestMutexSem:elink.
:dd.Request the specified mutex semaphore.
:dt.:link reftype=hd refid=sysreseteventsem.SysResetEventSem:elink.
:dd.Reset the specified event semaphore.
:dt.:link reftype=hd refid=syssaverexxmacrospace.SysSaveRexxMacroSpace:elink.
:dd.Save the REXX macrospace to a file.
:dt.:link reftype=hd refid=syssetextlibpath.SysSetExtLIBPATH:elink.
:dd.Set the value of the extended LIBPATH.
:dt.:link reftype=hd refid=syssetfiledatetime.SysSetFileDateTime:elink.
:dd.Modify a specified file's date/time attribute.
:dt.:link reftype=hd refid=syssetfilehandle.SysSetFileHandle:elink.
:dd.Set the number of available file handles for the current process.
:dt.:link reftype=hd refid=syssetpriority.SysSetPriority:elink.
:dd.Set the priority of the current process.
:dt.:link reftype=hd refid=syssetprocesscodepage.SysSetProcessCodePage:elink.
:dd.Set the codepage for the current process.
:dt.:link reftype=hd refid=sysshutdownsystem.SysShutDownSystem:elink.
:dd.Shut down the operating system.
:dt.:link reftype=hd refid=sysstemcopy.SysStemCopy:elink.
:dd.Copy items from one stem variable to another.
:dt.:link reftype=hd refid=sysstemdelete.SysStemDelete:elink.
:dd.Delete selected items from a stem variable.
:dt.:link reftype=hd refid=syssteminsert.SysStemInsert:elink.
:dd.Insert a new item into a stem variable at the specified position.
:dt.:link reftype=hd refid=sysstemsort.SysStemSort:elink.
:dd.Sort items within a stem variable.
:dt.:link reftype=hd refid=sysswitchsession.SysSwitchSession:elink.
:dd.Make the specified program the active session.
:dt.:link reftype=hd refid=sysutilversion.SysUtilVersion:elink.
:dd.Return the current version number of the RexxUtil library.
:dt.:link reftype=hd refid=sysversion.SysVersion:elink.
:dd.Return a string identifying the name and version of the operating system.
:dt.:link reftype=hd refid=syswaiteventsem.SysWaitEventSem:elink.
:dd.Wait on the specified event semaphore.
:dt.:link reftype=hd refid=syswaitforshell.SysWaitForShell:elink.
:dd.Wait until the WPS has initialized.
:dt.:link reftype=hd refid=syswildcard.SysWildCard:elink.
:dd.Transform a filename according to a wildcard pattern.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=rxmessagebox.RxMessageBox
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.RxMessageBox( text &rahead. 
                                                                           
 &rahead.)&rahead.&lahead. 
     ,               
          title   ,                 
                           button   ,                   
                                             icon                      
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Displays a standard Presentation Manager message box.  The message box is
centered on the screen and is non-modal.

:nt.RxMessageBox can only be used from a REXX program which is running as,
or from, a Presentation Manager process.  (This includes REXX code running
under PMREXX, as well as REXX called from a PM mode application.):ent.

:nt.It is not necessary to register the RxMessageBox function with
RxFuncAdd.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.text
:pd.The message box text.

:pt.title
:pd.The message box title.  The default title is "Error!".

:pt.button
:pd.The push buttons to appear on the message box.  The available styles
are&colon.

:dl break=fit tsize=22 compact.
:dt.OK
:dd.An 'OK' button.
:dt.OKCANCEL
:dd.OK and 'Cancel'buttons.
:dt.CANCEL
:dd.A 'Cancel' button.
:dt.ENTER
:dd.An 'Enter' button.
:dt.ENTERCANCEL
:dd.'Enter' and 'Cancel' buttons.
:dt.RETRYCANCEL
:dd.'Retry' and 'Cancel' buttons.
:dt.ABORTRETRYIGNORE
:dd.'Abort', 'Retry' and 'Ignore' buttons.
:dt.YESNO
:dd.'Yes' and 'No' buttons.
:dt.YESNOCANCEL
:dd.'Yes', 'No' and 'Cancel' buttons.
:edl.
:p.The default button style is 'OK'.

:pt.icon
:pd.The message box icon style. The available styles are&colon.
:dl break=fit tsize=22 compact.
:dt.NONE
:dd.No icon is displayed.
:dt.INFORMATION
:dd.An information icon is displayed.
:dt.QUERY
:dd.A query icon is displayed.
:dt.WARNING
:dd.A warning icon is displayed.
:dt.ERROR
:dd.An error icon is displayed.
:dt.ASTERISK
:dd.An information icon is displayed (equivalent to 'INFORMATION').
:dt.QUESTION
:dd.A query icon is displayed (equivalent to 'QUERY').
:dt.EXCLAMATION
:dd.A warning icon is displayed (equivalent to 'WARNING').
:dt.HAND
:dd.An error icon is displayed (equivalent to 'ERROR')
:edl.
:p.The default icon style is 'NONE'.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.RxMessageBox returns the message box button that was selected (pressed) by
the user.  The possible values are&colon.
:dl compact tsize=4.
:dt.1
:dd.The 'OK' button was pressed.
:dt.2
:dd.The 'Cancel' button was pressed.
:dt.3
:dd.The 'Abort' button was pressed.
:dt.4
:dd.The 'Retry' button was pressed.
:dt.5
:dd.The 'Ignore' button was pressed.
:dt.6
:dd.The 'Yes' button was pressed.
:dt.7
:dd.The 'No' button was pressed.
:dt.8
:dd.The 'Enter' button was pressed.
:edl.


:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Confirm exit
   */
  IF RxMessageBox('Really quit?', 'Confirm', 'YESNO', 'QUERY') == 6
      THEN EXIT
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysaddfilehandle.SysAddFileHandle
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysAddFileHandle( number )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Increases the number of file handles available to the current process.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.number
:pd.The number of additional file handles to make available.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysAddFileHandle returns the total number of file handles now available to
the process.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysaddrexxmacro.SysAddRexxMacro
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysAddRexxMacro( name, file )&rahead.&lahead. 
                                  , order                              
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Adds a function to the REXX macrospace.  The macrospace allows REXX
functions to be made available to all processes for immediate execution,
either from other REXX programs or through the RexxStart API.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.Name of the REXX function to be added to the macrospace.

:pt.file
:pd.File specification of the REXX program file containing the function
being added.

:pt.order
:pd.Position in the macrospace search order where the function is to be added,
relative to other functions in the macrospace.  The acceptable values are 'B'
(before) or 'A' (after).  The default is 'B'.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysAddRexxMacro returns the RexxAddMacro API return code.  Possible
values are&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.1
:dd.Insufficient memory.
:dt.7
:dd.File not found.
:dt.8
:dd.Invalid search order flag.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysbootdrive.SysBootDrive
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysBootDrive()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the current OS/2 boot drive.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysBootDrive returns the letter of the drive (volume) from which the
operating system was booted, followed by a colon; e.g. 'C&colon.'.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysclearrexxmacrospace.SysClearRexxMacroSpace
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysClearRexxMacroSpace()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Removes all loaded functions from the REXX macrospace.

:nt.Use this function with care, as it will clear the macrospace of all
functions, even those which were added by other processes.:ent.

:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysClearRexxMacroSpace returns the RexxClearMacroSpace API return code.
Possible values are&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.2
:dd.No functions were found in the macrospace.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscloseeventsem.SysCloseEventSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCloseEventSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Closes an event semaphore.
:nt.When there are no longer any running processes which have a semaphore open,
that semaphore is deleted.:ent.

:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of the event semaphore to be closed (as returned by a previous
call to :link reftype=hd refid=syscreateeventsem.SysCreateEventSem:elink.).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCloseEventSem returns the DosCloseEventSem API return code.  Possible
values are&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.301
:dd.Semaphore busy.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysclosemutexsem.SysCloseMutexSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCloseMutexSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Closes a mutex semaphore.
:nt.When there are no longer any running processes which have a semaphore open,
that semaphore is deleted.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of the mutex semaphore to close (as returned by a previous call
to :link reftype=hd refid=syscreatemutexsem.SysCreateMutexSem:elink.).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCloseMutexSem returns the DosCloseMutexSem return code.  Possible values
are&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.301
:dd.Semaphore busy.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscls.SysCls
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCls()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Clears the screen within the current VIO (text) session.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysCls returns 0.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscopyobject.SysCopyObject
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCopyObject( object, destination )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Creates a copy of an existing Workplace Shell object in the specified
destination folder.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.object
:pd.The name of the object to copy.  This can be specified as the object's
Workplace Shell object ID, or as a fully-qualified path name if the object
exists in the file system (this would apply to files and folders, but not
to program objects and other abstract types).

:pt.destination
:pd.The location in which the copy will be created.  This can be specified
as the object ID of an existing folder (e.g. '&lt.WP_DESKTOP&gt.'), or as the
path name of an existing file system directory (e.g. 'C&colon.\PROGRAMS').
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCopyObject returns the WinCopyObject API return code.  Possible values
are 1 if the operation succeeded, or 0 on failure.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscreateeventsem.SysCreateEventSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCreateEventSem()&rahead.&lahead. 
                         name                                          
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Creates or opens an event semaphore.
:nt.Creating a semaphore automatically opens it for all threads in the
current process.:ent.

:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The event semaphore name, which must include the prefix '\SEM32\'.
Semaphore names are validated by the file system; a maximum of 255 characters
is allowed.
:p.If an event semaphore by this name already exists, it will be opened;
otherwise, it will be created.
:p.If not specified, an unnamed shared event semaphore is created by default.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCreateEventSem returns an event semaphore handle, or else a null string
('') if the semaphore cannot be created or opened.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscreatemutexsem.SysCreateMutexSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCreateMutexSem()&rahead.&lahead. 
                         name                                          
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Creates or opens a mutex (mutual exclusion) semaphore.
:nt.Creating a semaphore automatically opens it for all threads in the
current process.:ent.

:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The mutex semaphore name, which must include the prefix '\SEM32\'.
Semaphore names are validated by the file system; a maximum of 255 characters
is allowed.
:p.If a mutex semaphore by this name already exists, it will be opened;
otherwise, it will be created.
:p.If not specified, an unnamed shared mutex semaphore is created by default.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.Returns a mutex semaphore handle, or else a null string ('') if the semaphore
cannot be created or opened.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscreateobject.SysCreateObject
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                        
 &rahead.&rahead.SysCreateObject( classname, title, location &rahead. 
                                                                        
 &rahead.)&rahead.&lahead. 
     ,                              
          setup   ,                                
                           option                                   
                                                                        

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Creates a new instance of a Workplace Shell class.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.classname
:pd.The name of the Workplace Shell class (e.g. 'WPProgram').

:pt.title
:pd.The title of the object being created (e.g. 'My New Object').

:pt.location
:pd.The location in which the new object will be created.  This can be
specified as the object ID of an existing folder (e.g. '&lt.WP_DESKTOP&gt.'),
or as the path name of an existing file system directory (e.g.
'C&colon.\PROGRAMS').

:pt.setup
:pd.A Workplace Shell setup string (as used by the WinCreateObject API function)
describing optional attributes for the new object.  The default is no setup
string (i.e. a null string), which results in the object being created according
to WPS defaults.
:p.Refer to :link reftype=hd refid=appendixb.Appendix B:elink. for a detailed
description of setup strings and their format.

:pt.option
:pd.The action to take if the object already exists.  The acceptable values
are&colon.
:dl compact break=fit.
:dt.FAIL
:dd.Do not create the object.  This is the default.
:dt.REPLACE
:dd.Delete the existing object and create the new object in its place.
:dt.UPDATE
:dd.Update the existing object with the new settings.
:edl.
:p.Only the first letter is required (e.g. 'F').
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCreateObject returns the WinCreateObject API return code.  The possible
values are 1 for successful object creation, or 0 for failure.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Create a new folder on the desktop.
   */
  IF SysCreateObject('WPFolder', 'My Folder', '&lt.WP_DESKTOP&gt.',,
                     'ICONVIEW=NONGRID,NORMAL;OBJECTID=&lt.MY_FOLDER&gt.', 'U') THEN DO
      SAY 'Folder "My Folder" was created successfully.'

      /* Create a program object for PROGRAM.EXE in the new folder.
       */
      IF SysCreateObject('WPProgram', 'Program', '&lt.MY_FOLDER&gt.',,
                         'EXENAME=C&colon.\BIN\PROGRAM.EXE;OBJECTID=&lt.PROGRAM&gt.') THEN
          SAY 'Program object "Program" was created successfully.'
  END
  ELSE SAY 'Could not create folder "My Folder".'
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscreateshadow.SysCreateShadow
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCreateShadow( object, destination )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Creates a shadow of an existing Workplace Shell object.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.object
:pd.The name of the object to shadow.  This can be specified as the object's
Workplace Shell object ID, or as a fully-qualified path name if the object
exists in the file system.

:pt.destination
:pd.The location in which the shadow will be created.  This can be specified
as the object ID of an existing folder (e.g. '&lt.WP_DESKTOP&gt.'), or as the
path name of an existing file system directory (e.g. 'C&colon.\PROGRAMS').
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCreateShadow returns the WinCreateShadow API return code.  The possible
values are 1 for successful shadow creation, or 0 for failure.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscurpos.SysCurPos
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCurPos()&rahead.&lahead. 
                 row, column                                           
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Moves the cursor to the specified row and column position, and/or returns
the cursor position, within the current text (VIO) session.

:nt.Calling SysCurPos with no parameters will return the current cursor position
without moving the cursor.:ent.

:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.row
:pd.The row number to move the cursor to.  Row 0 is the topmost row.
:pt.col
:pd.The column number to move the cursor to.  Column 0 is the leftmost column.
:eparml.
:p.Position (0,0) refers to the top left corner of the screen.

:p.
:p.:hp7.Result:ehp7.
:p.Returns the cursor position as it was immediately before calling this
function, in the form 'row col'.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  CALL SysCls
  cpos = SysCurPos( 3, 0 )
  PARSE VAR cpos row col
  SAY 'The cursor was located at 'row', 'col' prior to calling SysCurPos.'
  cp = SysCurPos()

:exmp.
:p.The following is the output from this example&colon.
:xmp.



The cursor was located at 0, 0 prior to calling SysCurPos.
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syscurstate.SysCurState
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysCurState( state )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Displays or hides the cursor within the current text (VIO) session.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.state
:pd.The new cursor state.  The acceptable values are&colon.
:dl break=none compact tsize=6.
:dt.ON
:dd.Display the cursor
:dt.OFF
:dd.Hide the cursor
:edl.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysCurState returns 0.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysderegisterobjectclass.SysDeregisterObjectClass
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDeregisterObjectClass( classname )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Deregisters an object class from the Workplace Shell.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.classname
:pd.The object class name.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysDeregisterObjectClass returns the WinDeregisterObjectClass API return
code.  Possible values are 1 for successful deregistration, or 0 for failure.




.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysdestroyobject.SysDestroyObject
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDestroyObject( name )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Destroys (deletes) an existing Workplace Shell object.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The name of the object to destroy.  This can be specified as the object's
Workplace Shell object ID, or as a fully-qualified path name if the object
exists in the file system.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysDestroyObject returns the WinDestroyData API return code. The possible
values are 1 for successful object deletion, or 0 for failure.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  IF SysDestroyObject('&lt.PROGRAM&gt.') THEN DO
      SAY 'Object "Program" was destroyed.'
      IF SysDestroyObject('&lt.MY_FOLDER&gt.') THEN
          SAY 'Folder "My Folder" was destroyed.'
  END
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysdriveinfo.SysDriveInfo
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDriveInfo( drive )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries information about a disk drive (volume).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.drive
:pd.The letter of the drive or volume to be queried (e.g. 'C&colon.').  A
trailing colon is optional.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysDriveInfo returns information about the queried drive in the format
:xmp.   drive&colon. free total label:exmp.
:p.where&colon.
:dl break=fit compact tsize=8.
:dt.drive&colon.
:dd.is the drive letter.
:dt.free
:dd.is the amount of free space on the drive, in bytes.
:dt.total
:dd.is the total size of the drive, in bytes.
:dt.label
:dd.is the drive's volume label.
:edl.
:p.If the drive is not accessible, then SysDriveInfo returns a null string
('').

:p.
:p.:hp7.Example:ehp7.
:xmp.
  SAY SysDriveInfo('D')
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  D&colon.  143790080    1064816640   DATA
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysdrivemap.SysDriveMap
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDriveMap()&rahead.&lahead. 
                   drive   , type                                  
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the available drive letters of the specified type.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.drive
:pd.The drive letter with which to start the query.  Drives prior to this
letter will be ignored.  The default is 'C&colon.'.  A trailing colon is
optional.
:pt.type
:pd.The type of drives to query.  The acceptable options are&colon.
:dl compact break=fit.
:dt.USED
:dd.Lists all drive letters which are in use on the system, including both local
and remote drives. This is the default.
:dt.FREE
:dd.Lists all drive letters which are unused.
:dt.LOCAL
:dd.Lists only local drives.
:dt.REMOTE
:dd.Lists only remote drives, such as LAN resources.
:dt.DETACHED
:dd.Lists detached LAN resources.
:edl.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysDriveMap returns a string of colon-suffixed drive letters, separated by
spaces.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  SAY 'Local drives&colon. ' SysDriveMap('A', 'LOCAL')
  SAY 'Remote drives&colon.' SysDriveMap(, 'REMOTE')
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  Local drives&colon.  A&colon. B&colon. C&colon. D&colon. S&colon.
  Remote drives&colon. Z&colon.
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysdropfuncs.SysDropFuncs
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDropFuncs()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Unloads all functions in the RexxUtil library.  After this function is
called, the RexxUtil functions will no longer be available to REXX programs
running in any session.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysDropFuncs returns 0.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysdroprexxmacro.SysDropRexxMacro
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDropRexxMacro( name )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Removes a function from the REXX macrospace.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.Name of the function to be removed from the macrospace.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.Returns the RexxDropMacro API return code.  Possible values are&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.2
:dd.Function was not found in the macrospace.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysdumpvariables.SysDumpVariables
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysDumpVariables()&rahead.&lahead. 
                        filename                                       
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Writes out all variables and their values within the current scope, either
to STDOUT or to the specified file.
:p.The data is written as one variable per line in the following format&colon.
:xmp.   Name=MYVAR, Value="This is the content of MYVAR":exmp.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.filename
:pd.The name of the file to which the variable data will be written.  Data
will be appended to the file if it exists.
:p.If this parameter is omitted, the data will be written directly to STDOUT
by default.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysDumpVariables returns one of the following values&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success
:dt.-1
:dd.Failure during dump
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syselapsedtime.SysElapsedTime
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysElapsedTime()&rahead.&lahead. 
                      option                                           
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Reports, and optionally resets, the number of seconds and microseconds on
the high-resolution elapsed time clock.  This function uses the operating
system's high-frequency timer, and provides greater granularity than the REXX
TIME function.

:p.The first call to SysElapsedTime within the current process will start the
elapsed time clock from zero.

:nt.Unlike the REXX TIME function, SysElapsedTime provides a single process-wide
time stamp.  Resetting the time stamp within a subroutine will be reflected in
the calling routine as well.:ent.

:nt.Multiple calls to SysElapsedTime within a single instruction will resolve
the time stamp independently of one another.:ent.

:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.option
:pd.Controls the behaviour of the call to SysElapsedTime.  The acceptable values
are&colon.
:dl compact break=none.
:dt.Elapsed
:dd.Returns the amount of time which has passed since the elapsed time clock was
started or reset.  This is the default.
:dt.Reset
:dd.Returns the amount of time which has passed since the elapsed time clock was
started or reset; the elapsed time clock is simultaneously reset to zero.
:edl.
:p.Only the first letter is required (e.g. 'E').
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysElapsedTime returns a time stamp in the following format&colon.
:xmp.   sssssssss.uuuuuu
:exmp.
where 'sssssssss' is one to nine digits representing seconds (no leading
zeros or spaces), and 'uuuuuu' is always six digits representing microseconds.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysfiledelete.SysFileDelete
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysFileDelete( file )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Deletes a single file.  Read-only files cannot be deleted with this function,
and neither can directories.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.file
:pd.The file specification of the file to be deleted.
:nt.Wildcards in the file specification are not supported.:ent.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysFileDelete returns one of the following values&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.File deleted successfully.
:dt.2
:dd.File not found.
:dt.3
:dd.Path not found.
:dt.5
:dd.Access denied.
:dt.26
:dd.Not a valid disk drive.
:dt.32
:dd.Sharing violation.
:dt.36
:dd.Sharing buffer exceeded.
:dt.87
:dd.Invalid parameter.
:dt.206
:dd.Filename exceeds range.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysfilesearch.SysFileSearch
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysFileSearch( target, file, stem )&rahead.&lahead. 
                                        , options                      
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Searches for occurances of the target string within the specified file.
All file lines containing the target string are saved to a REXX stem variable.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.target
:pd.The target string to search for.

:pt.file
:pd.The name of the file to be searched.

:pt.stem
:pd.The name of the stem variable in which the search results will be saved.
This variable will be returned with the contents&colon.
:dl compact break=none.
:dt.:hp1.stem:ehp1..0
:dd.:hp1.n:ehp1.
:dt.:hp1.stem:ehp1..1
:dd.The first matching line from the file (if :hp1.n:ehp1. &gt. 0)
:dt.:hp1.stem:ehp1..2
:dd.The second matching line from the file (if :hp1.n:ehp1. &gt. 1)
:dt....
:dd.
:dt.:hp1.stem.n:ehp1.
:dd.The :hp1.n:ehp1.th matching line from the file
:edl.
:p.Where :hp1.n:ehp1. is the total number of lines returned.

:pt.options
:pd.Any combination of the following one-character options&colon.
:dl compact break=none tsize=5.
:dt.'C'
:dd.Search case-sensitively.
:dt.'N'
:dd.Include line numbers in the lines returned.
:edl.
:p.If not specified, the default behaviour is to search case-insensitively, and
without returning line numbers.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysFileSearch returns one of the following return codes&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.2
:dd.Not enough memory.
:dt.3
:dd.Error opening file.
:edl.

:p.
:p.:hp7.Examples:ehp7.
:p.An example of SysFileSearch with default options&colon.
:xmp.
  /* Find all RUN statements in CONFIG.SYS
   */
  CALL SysFileSearch 'RUN=', SysBootDrive() || '\CONFIG.SYS', 'found.'
  DO i = 1 TO found.0
      SAY found.i
  END
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  RUN=C&colon.\OS2\EPW.EXE
  RUN=C&colon.\OS2\SYSTEM\LVMALERT.EXE
  RUN=C&colon.\OS2\EXTENDFS.EXE *
  RUN=C&colon.\OS2\APMDAEMN.EXE
  RUN=C&colon.\IBMCOM\LANMSGEX.EXE
  RUN=C&colon.\MPTN\BIN\AFNBINI.EXE
  RUN=C&colon.\MPTN\BIN\CNTRL.EXE
  RUN=C&colon.\IBMCOM\PROTOCOL\NBTCP.EXE
  RUN=C&colon.\MPTN\BIN\VDOSCTL.EXE
  RUN=C&colon.\OS2\SMSTART.EXE
  RUN=C&colon.\IBMLAN\NETPROG\LSDAEMON.EXE
  RUN=C&colon.\IBMLAN\NETPROG\VNRMINIT.EXE
  RUN=C&colon.\OS2\SYSTEM\LOGDAEM.EXE
  RUN=C&colon.\OS2\EPWROUT.EXE 1
:exmp.

:p.An example of SysFileSearch which returns line numbers&colon.
:xmp.
  /* Find all IFS statements in CONFIG.SYS, and include line numbers
   */
  CALL SysFileSearch 'IFS=', SysBootDrive() || '\CONFIG.SYS', 'found.', 'N'
  DO i = 1 TO found.0
      SAY found.i
  END
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  11 IFS=C&colon.\OS2\JFS.IFS /LW&colon.5,20,4 /AUTOCHECK&colon.*
  12 IFS=C&colon.\IBM386FS\HPFS386.IFS /A&colon.*
  13 IFS=C&colon.\OS2\BOOT\UDF.IFS /Q
  14 IFS=C&colon.\OS2\BOOT\CDFS.IFS /Q /W
  50 IFS=C&colon.\IBMLAN\NETPROG\NETWKSTA.200 /I&colon.C&colon.\IBMLAN /N
  54 IFS=C&colon.\MPTN\bin\nfs300.ifs
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysfilesystemtype.SysFileSystemType
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysFileSystemType( drive )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the file system in use on the specified drive (volume).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.drive
:pd.The drive letter of the volume to query, for example 'C&colon.'.  The
trailing colon is optional.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysFileSystemType returns the name of the file system in use (e.g.
'HPFS').  If the drive is not accessible, a null string ('') is returned.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  cfs = SysFileSystemType('C')
  efs = SysFileSystemType('E')
  SAY 'The file system on drive C&colon. is' cfs
  SAY 'The file system on drive E&colon. is' efs
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  The file system on drive C&colon. is HPFS
  The file system on drive E&colon. is JFS
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysfiletree.SysFileTree
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysFileTree( filespec, stem &rahead. 
                                                                           
 &rahead.)&rahead.&lahead. 
     ,         
          options   ,           
                             tattrib   ,             
                                                nattrib                
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Finds all files and/or directories which match the given file specification
and attributes.  The results are stored in a REXX stem variable.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.filespec
:pd.The file specification to search for.  This is a standard OS/2 file
specification and may include wildcard characters.

:pt.stem
:pd.The name of the stem variable in which the search results will be saved.
This variable will be returned with the contents&colon.
:dl compact break=none.
:dt.:hp1.stem:ehp1..0
:dd.:hp1.n:ehp1.
:dt.:hp1.stem:ehp1..1
:dd.The first match found (if :hp1.n:ehp1. &gt. 0)
:dt.:hp1.stem:ehp1..2
:dd.The second match found (if :hp1.n:ehp1. &gt. 1)
:dt....
:dd.
:dt.:hp1.stem.n:ehp1.
:dd.The :hp1.n:ehp1.th match found.
:edl.
:p.Where :hp1.n:ehp1. is the total number of matches returned.
:p.The format of each stem entry depends on the options specified; refer to the
description of the second parameter for details.

:pt.options
:pd.Any combination of the following one-character options&colon.
:dl compact break=none tsize=5.
:dt.F
:dd.Search for files only.
:dt.D
:dd.Search for directories only.
:dt.B
:dd.Search for both files and directories (this is the default).
:dt.S
:dd.Search into subdirectories recursively.
:dt.T
:dd.Use the format ':hp1.YY/MM/DD/hh/mm:ehp1.' when returning the date and time.
:dt.L
:dd.Use the format ':hp1.YYYY-MM-DD hh&colon.mm&colon.ss:ehp1.' when returning
the date and time.
:dt.O
:dd.Return the fully qualified file name only.
:edl.
:nt.'F', 'D', and 'B' are mutually exclusive with one another, as are 'T', 'L',
 and 'O'.  If more than one mutually exclusive option is specified, the last one
listed will take precedence.:ent.
:nt.The 'L' option was introduced for Y2K compatibility starting with OS/2 Warp
3 FixPak 35 and Warp 4 FixPak 6.:ent.
:p.The default behaviour is to search for both files and directories.  If the
'O' option was specified, each stem entry will contain the fully-qualified
filename by itself.
:p.Otherwise, each stem entry will contain the following fields&colon.
:hp1.MDate MTime Size Attributes Filename:ehp1.
:p.:hp1.MDate:ehp1. and :hp1.MTime:ehp1. are the date and time, respectively,
that the file was last modified.  If neither 'T' nor 'L' is specified in the
search options, the date and time will be returned in a default format; see
the example (below) for an illustration.
:p.:hp1.Size:ehp1. is the file's size in bytes.
:p.:hp1.Attributes:ehp1. is a five-character string representing the file's
attributes, in the order 'ADHRS' (Archive, Directory, Hidden, Read-only, and
System).  Those attributes not present will be represented by '-'.  These
indicate the attribute settings after the new attribute mask (if specified)
has been applied; see the description of the last parameter for details.
:p.:hp1.Filename:ehp1. is the fully-qualified filename.

:pt.tattrib
:pd.An attribute mask indicating the target file attributes to match when
searching.  Only files which match this mask will be returned by the search.

:p.The attribute mask is a five-character string representing, in order, the
Archive, Directory, Hidden, Read-only, and System attributes (ADHRS).  Each
character must be one of the following&colon.
:dl compact break=none tsize=4.
:dt.*
:dd.The attribute may be any state.
:dt.+
:dd.The attribute must be set.
:dt.-
:dd.The attribute must be cleared.
:edl.
:p.The default target attribute mask is '*****', which will match every file
regardless of the state of any of its attributes.

:pt.nattrib
:pd.An attribute mask indicating the new file attributes which will be applied to
each matching file.
:p.The attribute mask is a five-character string representing, in order, the
Archive, Directory, Hidden, Read-only, and System attributes (ADHRS).  Each
character must be one of the following&colon.
:dl compact break=none tsize=4.
:dt.*
:dd.The attribute will be left unchanged from its current state.
:dt.+
:dd.The attribute will be set.
:dt.-
:dd.The attribute will be cleared.
:edl.
:p.The default new attribute mask is '*****', which will leave all file attributes
unchanged from their current state.
:nt.The Directory attribute cannot be set on non-directory files.:ent.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.When SysFileTree completes successfully, the specified stem variable will
contain the information on each matching file.  The function itself returns
one of the following values&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Operation completed successfully.
:dt.2
:dd.Not enough memory.
:edl.

:p.
:p.:hp7.Examples:ehp7.
:xmp.
  /* Find all subdirectories of C&colon.\OS2, and display the results as
   * filenames only.
   */
  CALL SysFileTree 'C&colon.\OS2\*', 'found1.', 'DO'
  DO i = 1 TO found1.0
      SAY found1.i
  END
  SAY

  /* Clear the Hidden and Readonly attributes of any file under C&colon.\ whose name
   * starts with 'OS2' and which has the System attribute set.  Then display
   * the full results.
   */
  CALL SysFileTree 'C&colon.\OS2*', 'found2.', 'F', '****+', '**--*'
  DO i = 1 TO found2.0
      SAY found2.i
  END
:exmp.

:p.The following is a sample of output from this example&colon.
:xmp.
  C&colon.\OS2\APPS
  C&colon.\OS2\ARCHIVES
  C&colon.\OS2\BITMAP
  C&colon.\OS2\BOOK
  C&colon.\OS2\BOOT
  C&colon.\OS2\DLL
  C&colon.\OS2\DRIVERS
  C&colon.\OS2\ETC
  C&colon.\OS2\HELP
  C&colon.\OS2\INSTALL
  C&colon.\OS2\JAVAAPPS
  C&colon.\OS2\MDOS
  C&colon.\OS2\PDPSI
  C&colon.\OS2\POINTERS
  C&colon.\OS2\SCR
  C&colon.\OS2\SYSTEM

  11/25/02  11&colon.40a       51132  A---S  C&colon.\OS2BOOT
   2/13/02   3&colon.09p       14989  A---S  C&colon.\OS2DUMP
   2/13/02   2&colon.10p      847335  A---S  C&colon.\OS2KRNL
   2/13/02   3&colon.13p       44544  A---S  C&colon.\OS2LDR
   3/15/99   6&colon.36p        8926  A---S  C&colon.\OS2LDR.MSG
   6/27/02  10&colon.27p      104362  A---S  C&colon.\OS2LOGO
  11/25/02   2&colon.56p          73  A---S  C&colon.\OS2VER
:exmp.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysgetcollate.SysGetCollate
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysGetCollate()&rahead.&lahead. 
                     country   , codepage                          
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Retrieves the collating sequence table for the specified country and
codepage combination.  A collating sequence table is a complete list of the
characters within a character set, in their proper sort order.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.country
:pd.The three-digit country code.  A value of 0 indicates the currently-active
country code; this is also the default if not specified.
:pt.codepage
:pd.The codepage number.  A value of 0 indicates the currently-active codepage;
this is also the default if not specified.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysGetCollate returns a 256-character string containing the collating
sequence table.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysgetea.SysGetEA
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysGetEA( file, attribute, variable )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Retrieves the value of the specified extended attribute value from a file,
and saves it under the specified variable.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.file
:pd.The name of the file whose extended attribute is being queried.
:pt.attribute
:pd.The name of the extended attribute being queried.
:pt.variable
:pd.The name of the REXX variable into which the extended attribute's value
will be placed.
:p.Refer to :link reftype=hd refid=appendixa.Appendix A:elink. for a detailed
description of extended attributes and their format.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.Returns 0 if successful, or an OS/2 system error code on failure.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* This code reads and displays the file type defined in the file's .TYPE EA.
   */
  input_file = 'C&colon.\STARTUP.CMD'

  IF SysGetEA( input_file, '.TYPE', 'types') == 0 THEN DO
      /* Get the data type of the extended attribute by reading the first two
       * bytes.  For the .TYPE EA, this will be either ASCII ('FDFF'), or
       * multi-type value list ('DFFF').
       */
      PARSE VAR types 1 p_data 3 .

      IF C2X( p_data ) == 'FDFF' THEN
          /* When the .TYPE EA is a single ASCII value, we can simply parse
           * that value as text starting at byte 5.
           */
          PARSE VAR types 5 text

      ELSE DO
          /* When the .TYPE EA is a multi-type value list, we can get the total
           * number of list items by parsing the two bytes starting at byte 5
           * (although in this example we don't use it).  We get the actual list
           * of items by parsing from byte 7 onwards.
           */
          PARSE VAR types 5 p_count 7 p_items

          /* Now we parse the first value out of the list.  The first two bytes are
           * the data type; for the .TYPE EA this will always be ASCII ('FDFF'), so
           * we can skip them.  Bytes 3 and 4 are a WORD representing the length of
           * the first value; we convert this to a useable number by reversing the
           * byte order.
           */
          PARSE VAR p_items 3 p_len 5 p_rest
          len = C2D( REVERSE( p_len ))

          /* Now we use this length value to parse the actual text out of the bytes
           * that follow.
           */
          text = SUBSTR( p_rest, 1, len )
      END

      /* NOTE: In this example, we are only reading the first .TYPE value from
       *       the list.  If there are additional values defined, they will be
       *       ignored.
       */

      IF text == '' THEN
          SAY 'No file type EA is defined.'
      ELSE
          SAY 'The file type is&colon.' text

  END
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  The file type is&colon. OS/2 Command File
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysgetfiledatetime.SysGetFileDateTime
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysGetFileDateTime( filename )&rahead.&lahead. 
                                   , timesel                           
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries one of the specified file's date/time attributes.  The possible
date/time attributes available for querying are, depending on the file system
in question&colon. file creation, most recent access, and most recent write.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.filename
:pd.The name of the file to be queried.  This file must be available for
reading; that is, it cannot be locked for exclusive reads by another process.

:p.Under OS/2 and Windows NT, this parameter may be the name of a directory.
However, this is not allowed under Windows 95/98, AIX, or Linux.

:pt.timesel
:pd.The date/time attribute to query.  Possible values are&colon.
:dl compact break=none.
:dt.CREATE
:dd.File creation
:dt.ACCESS
:dd.Most recent access
:dt.WRITE
:dd.Most recent write
:edl.
:p.Only the first character needs to be specified.  'WRITE' ('W') is the default.

:nt.The FAT file system supports only the 'WRITE' attribute.:ent.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.Returns the date and time in the form&colon.
:xmp.   YYYY-MM-DD hh&colon.mm&colon.ss
:exmp.
or -1 if the query failed.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysgetkey.SysGetKey
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysGetKey()&rahead.&lahead. 
                 opt                                                   
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Reads a key from the keyboard buffer and returns its value.  If the buffer
is empty, SysGetKey waits until a key is pressed.  The key value is returned
immediately; SysGetKey does not wait for the Enter key to be pressed.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.opt
:pd.Determines whether the pressed key is echoed (displayed on screen).
Possible values are&colon.
:dl compact break=none.
:dt.ECHO
:dd.Echo the key to the screen.
:dt.NOECHO
:dd.Do not echo the key.
:edl.
:p.The option value must be specified in full (the first character is not
sufficient).  'ECHO' is the default.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.Returns the character code of the pressed key.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysgetmessage.SysGetMessage
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
                                     Ŀ                        
                                                                         
 &rahead.&rahead.SysGetMessage( num )&rahead.&lahead. 
                         , file       (1)                            
                                       , str                           
                                                                           
 NOTE&colon.                                                                     
 (1)  You can use up to 9 insertion text variables.                        
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Retrieves the specified text string from an OS/2 message file.

:p.Message files are used to store text messages (strings) for national-language
support.  Every message in the file has an associated number; an application
can use this number to retrieve the specified message from the message file
instead of hard-coding the text in its own program code.  This allows a program
to support different languages simply by changing the message file.

:p.Variable substitution may be performed on the returned string for up to nine
variables, so long as that particular string supports it.

:p.Message files are created using the :hp2.MKMSGF:ehp2. utility, which is
part of the IBM Developer's Toolkit.  (If you have the Toolkit installed, you
can click :link reftype=launch object='view.exe' data='toolsref MKMSGF'.here:elink.
for more information.)

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.num
:pd.The message number being requested.

:pt.file
:pd.The name of the message file containing the message.  This can be specified
with or without the full path; in the latter case, SysGetMessage will search for
the message file in the following locations&colon.
:ol compact.
:li.The system root directory.
:li.The current directory.
:li.Directories specified in the current DPATH.
:eol.
:p.If not specified, the default message file is 'OSO001.MSG'.

:pt.str
:pd.Variable substitution strings (up to nine).
:p.If the message contains variable fields of the form %1 to %9, these will be
replaced with the substitution strings specified, in the order given.
:p.Substitution strings which cannot be matched to variable fields in the
message will be ignored.

:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.If successful, the requested message text will be returned with any specified
substitutions made.
:p.If an error occurred, an operating system error message string will be
returned instead.  This would typically be a SYS3017 error if the requested
message number could not be found, or a SYS3018 error if the specified message
file could not be found.


:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* MINE.MSG includes the following message definitions:
   *
   * MIN0001I: Hello, world.
   * MIN0002I: Please insert the diskette with the file %1 and then press Enter.
   */
  SAY SysGetMessage( 1 )
  SAY
  SAY SysGetMessage( 1, 'MINE.MSG')
  SAY
  SAY SysGetMessage( 2, 'MINE.MSG', 'REGISTER.TXT')
  SAY
  SAY SysGetMessage( 99, 'MINE.MSG')
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  Incorrect function

  Hello, world.

  Please insert the diskette with the file REGISTER.TXT and then press Enter.

  SYS0317: The system cannot find message 99
  in message file MINE.MSG.
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysini.SysIni
:p.:hp7.Syntax:ehp7.
:p.The SysIni function has six modes, each of which requires a different
syntax&colon.
:ol compact.
:li.Setting a single key
:li.Querying a single key
:li.Deleting a single key
:li.Deleting an application and all of its keys
:li.Querying the names of all of an application's keys
:li.Querying the names of all applications
:eol.
:p.The syntax variations are listed below.

:p.:hp2.1. Setting a single key:ehp2.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysIni(, application, key, value )&rahead.&lahead. 
              inifile                                                  
                                                                           

:ecgraphic.

:p.:hp2.2. Querying a single key:ehp2.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysIni(, application, key )&rahead.&lahead. 
              inifile                                                  
                                                                           

:ecgraphic.

:p.:hp2.3. Deleting a single key:ehp2.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysIni(, application, key, 'DELETE&colon.' )&rahead.&lahead. 
              inifile                                                  
                                                                           

:ecgraphic.

:p.:hp2.4. Deleting an application and all of its keys:ehp2.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysIni(, application )&rahead.&lahead. 
              inifile                 , 'DELETE&colon.'                  
                                                                           

:ecgraphic.

:p.:hp2.5. Querying the names of all keys for an application:ehp2.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysIni(, application, 'ALL&colon.', stem )&rahead.&lahead. 
              inifile                                                  
                                                                           

:ecgraphic.

:p.:hp2.6. Querying the names of all applications:ehp2.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysIni(, 'ALL&colon.', stem )&rahead.&lahead. 
              inifile                                                  
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.The SysIni function provides access to OS/2 INI (profile) files.

:p.An INI file is a special binary database which contains 'applications' and
'keys'.
:ul compact.
:li.A 'key' is a variable which has some data value associated with it; the
stored value can be null-terminated text, a numeric value, or arbitrary binary
data.
:li.An 'application' is a group of keys categorized together under the same
name.
:eul.

:p.INI files are commonly used to store configuration data under OS/2.  Many
individual applications maintain their own INI files, as does the OS/2 system
itself.

:nt.If the specified INI file does not exist, SysIni will create it.  This
occurs even when performing query operations (in which case an empty file
will be created).  For this reason, you should verify that an INI file exists
before attempting to query a value from it.:ent.

:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.inifile
:pd.The name of the INI file being operated on.  This is either a complete
file specification, or one of the following&colon.
:dl compact break=none.
:dt.USER
:dd.The OS/2 'user' INI file, as defined by the environment variable
:hp2.USER_INI:ehp2. (this is typically :hp2.C&colon.\OS2\OS2.INI:ehp2.,
where C&colon. is the OS/2 boot drive).
:dt.SYSTEM
:dd.The OS/2 'system' INI file, as defined by the environment variable
:hp2.SYSTEM_INI:ehp2. (this is typically :hp2.C&colon.\OS2\OS2SYS.INI:ehp2.,
where C&colon. is the OS/2 boot drive).
:dt.BOTH
:dd.For query operations, indicates that both the user and system INI
files will be searched.  For set and delete operations, this has the same effect
as specifying 'USER', i.e. only the user INI file will be updated.
:edl.
:p.If nothing is specified, 'USER' is the default.

:pt.application
:pd.The name of the application to be operated on.  This is a string value.

:pt.key
:pd.The name of the key to be operated on.  This is a string value.

:pt.value
:pd.The value associated with the specified key (for set operations).  Binary,
numeric, and text values are all allowed.
:ul.
:li.Text values in INI files are identified by a terminating null character
('00'x).  SysIni itself neither appends nor strips null characters when setting
or querying values; it is up to the programmer to do so.
:li.Single numeric values are stored within the INI file as four-byte (DWORD)
integers.  These must be specified as eight-digit hexadecimal values in reverse
(i.e. right-to-left or &osq.little-endian&csq.) byte order.  For example, to
write the value 31 (0x1F) as an integer, it must be passed to SysIni using
syntax similar to one of following&colon.
:xmp.    REVERSE('0000001F'x )
    REVERSE( X2C( D2X( 31, 8 )))
:exmp.
:li.Any other specified value will be treated as arbitrary binary data.
:eul.

:pt.stem
:pd.The name of a stem variable in which the returned data will be stored.
This variable will be returned with the contents&colon.
:dl compact break=none.
:dt.:hp1.stem:ehp1..0
:dd.:hp1.n:ehp1.
:dt.:hp1.stem:ehp1..1
:dd.The name of the first match (if :hp1.n:ehp1. &gt. 0)
:dt.:hp1.stem:ehp1..2
:dd.The name of the second match (if :hp1.n:ehp1. &gt. 1)
:dt....
:dd.
:dt.:hp1.stem.n:ehp1.
:dd.The name of the :hp1.n:ehp1.th match
:edl.
:p.Where :hp1.n:ehp1. is the total number of matches returned.

:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.For successful set or delete operations, SysIni returns the empty string ('').
:p.For a successful query of a single key value, SysIni returns the value of the
requested key.
:p.For a successful query of multiple values (either key values or application
names), SysIni returns the empty string and places the query results into the
specified REXX stem variable.

:p.In the event of an error, SysIni returns the string 'ERROR&colon.'.
:p.An error may result if a non-existing application or key name was specified,
or if the requested INI file could not be opened.


:p.
:p.:hp7.Examples:ehp7.
:xmp.
  /* Our INI file (presumed to be in the current directory).
   */
  ini   = 'TEAM.INI'


  /* Various data to be written.
   */
  boy1  = 'Fred'
  boy2  = 'George'
  boy3  = 'Oliver'
  girl1 = 'Alicia'
  girl2 = 'Angelina'
  girl3 = 'Katie'


  /* Setting individual key values.  Append a null character to store them
   * as string values instead of binary.
   */
  CALL SysIni ini, 'Boys',  'Name 1', boy1  || '00'x
  CALL SysIni ini, 'Boys',  'Name 2', boy2  || '00'x
  CALL SysIni ini, 'Boys',  'Name 3', boy3  || '00'x
  CALL SysIni ini, 'Girls', 'Name 1', girl1 || '00'x
  CALL SysIni ini, 'Girls', 'Name 2', girl2 || '00'x
  CALL SysIni ini, 'Girls', 'Name 3', girl3 || '00'x


  /* Querying a single key value.  The terminating null gets returned as
   * well, so we strip it off using PARSE.
   */
  namez = SysIni( ini, 'Girls', 'Name 3')
  PARSE VAR namez name '00'x .
  SAY 'Girls->Name 3 = "'name'"'
  SAY


  /* Querying all of an application's keys.
   */
  CALL SysIni ini, 'Boys', 'ALL&colon.', 'keys.'
  DO i = 1 TO keys.0
      namez = SysIni( ini, 'Boys', keys.i )
      PARSE VAR namez name '00'x .
      SAY 'Boys->'keys.i '= "'name'"'
  END
  SAY


  /* Querying the names of all applications.
   */
  CALL SysIni ini, 'ALL&colon.', 'apps.'
  SAY ini 'contains the following applications&colon.'
  DO i = 1 TO apps.0
      SAY '"'apps.i'"'
  END
  SAY


  /* Deleting a single key.
   */
  CALL SysIni ini, 'Boys', 'Name 3', 'DELETE&colon.'


  /* Deleting an entire application.
   */
  CALL SysIni ini, 'Boys'

  CALL SysIni ini, 'ALL&colon.', 'apps.'
  SAY ini 'contains the following applications&colon.'
  DO i = 1 TO apps.0
      SAY '"'apps.i'"'
  END
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  Girls->Name 3 = "Katie"

  Boys->Name 1 = "Fred"
  Boys->Name 2 = "George"
  Boys->Name 3 = "Oliver"

  TEAM.INI contains the following applications&colon.
  "Boys"
  "Girls"

  TEAM.INI contains the following applications&colon.
  "Girls"
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysloadfuncs.SysLoadFuncs
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysLoadFuncs()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Loads all functions in the RexxUtil library.  After this function is called,
the RexxUtil functions will be available to all REXX programs, including those
running in other sessions.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysLoadFuncs returns 0.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysloadrexxmacrospace.SysLoadRexxMacroSpace
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysLoadRexxMacroSpace( file )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Loads functions into the REXX macrospace from a file created by the
SysSaveRexxMacroSpace function.

:nt.Existing macrospace functions cannot be replaced by this operation.  If
a function in the requested file already exists in the current macrospace,
SysLoadRexxMacroSpace will return an error, and the current macrospace will
remain unchanged.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.file
:pd.The file from which functions will be loaded into the REXX macrospace.
This file must have been previously created by SysSaveRexxMacroSpace.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysLoadRexxMacroSpace returns the RexxLoadMacroSpace API return code.
Possible values are&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.1
:dd.Not enough memory.
:dt.2
:dd.Macrospace function(s) not found.
:dt.4
:dd.Duplicate function exists in the macrospace.
:dt.5
:dd.Error accessing file.
:dt.6
:dd.Saved macrospace file is not valid.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysmapcase.SysMapCase
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysMapCase( string )&rahead.&lahead. 
                         , country                    
                                      , codepage                       
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Converts a string to uppercase, according to the national language rules
for the specified country and codepage.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.string
:pd.String to be converted to uppercase.
:pt.country
:pd.The three-digit country code.  A value of 0 indicates the currently-active
country code; this is the default.
:pt.codepage
:pd.The codepage number.  A value of 0 indicates the currently-active codepage;
this is the default.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.Returns the uppercased form of the specified string.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysmkdir.SysMkDir
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysMkDir( dirspec )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Creates a new directory.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.dirspec
:pd.The name of the directory to create, which must be valid for the
filesystem in use.  This can be a fully-qualified name, or relative
to the current working path.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysMkDir returns one of the following values&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.2
:dd.File not found.
:dt.3
:dd.Path not found.
:dt.5
:dd.Access denied.
:dt.26
:dd.Not a DOS disk.
:dt.87
:dd.Invalid parameter.
:dt.108
:dd.Drive locked.
:dt.206
:dd.Filename exceeds range.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysmoveobject.SysMoveObject
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysMoveObject( object, destination )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Moves a Workplace Shell object to the specified folder.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.object
:pd.The name of the object to move, which must exist.  This can be specified
as an object ID (e.g. '&lt.WP_SYSTEM&gt.'), or as a fully-qualified filename
if the object exists in the file system (this would apply to files and folders,
but not to program objects and other abstract types).
:pt.destination
:pd.The name of the target folder to which the specified object will be moved.
This can be specified as an object ID (e.g. '&lt.WP_DESKTOP&gt.'), or as a
fully-qualified filename (e.g. 'C&colon.\DESKTOP').
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysMoveObject returns the WinMoveObject API return code.  Possible values
are 1 if the operation succeeded, or 0 on failure.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Move the Drives folder to the desktop.
   */
  CALL SysMoveObject '&lt.WP_DRIVES&gt.', '&lt.WP_DESKTOP&gt.'
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysnationallanguagecompare.SysNationalLanguageCompare
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysNationalLanguageCompare( string1, string2 &rahead. 
                                                                           
 &rahead.)&rahead.&lahead. 
    ,                            
          country   ,                              
                              codepage                                 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Compares two strings for equality, according to the collating table for
the specified country and codepage combination.

:nt.If either of the strings is longer than the other, the strings are compared
up to the length of the shorter string.  If this portion is equal, then the
longer string is considered to have a greater value.  (Strings of differing
length can never be equal.):ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.string1
:pd.The first string to compare.
:pt.string2
:pd.The second string to compare.
:pt.country
:pd.The three-digit country code.  A value of 0 indicates the currently-active
country code; this is the default.
:pt.codepage
:pd.The codepage number.  A value of 0 indicates the currently-active codepage;
this is the default.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysNationalLanguageCompare returns one of the following values&colon.
:dl compact break=none tsize=5.
:dt.0
:dd.string1 and string2 are equal.
:dt.1
:dd.string1 has a greater value than string2.
:dt.-1
:dd.string2 has a greater value than string1.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysopeneventsem.SysOpenEventSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysOpenEventSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Opens an event semaphore.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 event semaphore, as returned from a
previous call to :link reftype=hd refid=syscreateeventsem.SysCreateEventSem:elink..
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysOpenEventSem returns the DosOpenEventSem API return code.  Possible
values include&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.8
:dd.Not enough memory.
:dt.87
:dd.Invalid parameter.
:dt.123
:dd.Invalid name.
:dt.187
:dd.Semaphore not found.
:dt.291
:dd.Too many opens.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysopenmutexsem.SysOpenMutexSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysOpenMutexSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Opens a mutex semaphore.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 mutex semaphore, as returned from a previous
call to :link reftype=hd refid=syscreatemutexsem.SysCreateMutexSem:elink..
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysOpenMutexSem returns the DosOpenMutexSem API return code.  Possible
values include&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.8
:dd.Not enough memory.
:dt.87
:dd.Invalid parameter
:dt.105
:dd.Semaphore owner died.
:dt.123
:dd.Invalid name.
:dt.187
:dd.Semaphore not found.
:dt.291
:dd.Too many opens.
:edl.



.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysopenobject.SysOpenObject
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysOpenObject( name, view, flag )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Opens an existing Workplace Shell object according to the specified view.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The name of the object to open, which must exist.  This can be specified
as an object ID (e.g. '&lt.WP_CONFIG&gt.'), or as a fully-qualified filename
if the object exists in the file system (this would apply to files and folders,
but not to program objects and other abstract types).

:pt.view
:pd.The view in which to open the object, which can be one of the standard
Workplace Shell views or a user-defined view.  The view may be given as an
integer value, or as one of the following&colon.
:dl compact break=none.
:dt.SETTINGS
:dd.Open the object's settings dialog.
:dt.DEFAULT
:dd.Open the object's default view.  This has the same effect as double-clicking
on the object's icon.
:dt.ICON
:dd.Open the object in icon view (folders only).
:dt.RUNNING
:dd.Execute a program object or executable.
:dt.HELP
:dd.Open the object's default help panel.
:dt.PALETTE
:dd.Open a palette object.
:dt.PROMPTDLG
:dd.Open a prompt dialog object.
:edl.
:p.If the specified view is not applicable to the object, the operation will
have no effect (although the function call will complete successfully).

:pt.flag
:pd.Specifies whether to open an existing view of the object, or a new view.
Must be one of&colon.
:dl compact break=none.
:dt.TRUE
:dd.Surface an existing view of the object if possible; otherwise, open a new
view.
:dt.FALSE
:dd.Open a new view of the object.
:edl.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysOpenObject returns the WinOpenObject API return code.  Possible values
are 1 if the object was opened successfully, or 0 on failure.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysos2ver.SysOS2Ver
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysOS2Ver()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Returns the current version of the OS/2 operating system.  This is the
basic system version reported by the OS/2 kernel, and does not include service
levels.
:nt.This function is specific to the OS/2 environment.  If portability to
other platforms is required, you should used the
:link reftype=hd refid=sysversion.SysVersion:elink. function instead.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysOS2Ver returns a string in the form :hp1.x:ehp1..:hp1.yy:ehp1., where
:hp1.x:ehp1. is the OS/2 major version number, and :hp1.yy:ehp1. is the OS/2
minor version number.  Note that all 32-bit versions of OS/2 report a major
version of 2, in which instance the returned string should be interpreted as
follows&colon.
:dl compact tsize=7.
:dt.2.00
:dd.OS/2 version 2.0
:dt.2.10
:dd.OS/2 version 2.1
:dt.2.11
:dd.OS/2 version 2.11
:dt.2.30
:dd.OS/2 version 3.0
:dt.2.40
:dd.OS/2 version 4.0
:dt.2.45
:dd.OS/2 version 4.5
:edl.

:nt.OS/2 Warp 4 will report version 2.45 under FixPak 13 or higher, due to the
merging of the OS/2 version 4.5 kernel into the Warp 4 code base.:ent.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysposteventsem.SysPostEventSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysPostEventSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Posts an event semaphore.  Threads that were blocked on SysWaitEventSem
for that semaphore will be unblocked.
:nt.If the semaphore was created by another process, it must first be opened
with SysOpenEventSem.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 event semaphore, as returned from a previous
call to :link reftype=hd refid=syscreateeventsem.SysCreateEventSem:elink..
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysPostEventSem returns the DosPostEventSem API return code.  Possible
values include&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success
:dt.6
:dd.Invalid handle.
:dt.298
:dd.Too many posts.
:dt.299
:dd.Already posted.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysprocesstype.SysProcessType
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysProcessType()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the type of the process in which the REXX program is running.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysProcessType returns one of the following values&colon.
:dl compact tsize=4.
:dt.0
:dd.Full-screen protected mode.
:dt.1
:dd.Real mode.
:dt.2
:dd.Windowable (VIO) protected mode.
:dt.3
:dd.Presentation Manager protected mode.
:dt.4
:dd.Detached protected mode.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysputea.SysPutEA
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysPutEA( file, name, value )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Writes an extended attribute (EA) to a file or directory.

:p.Extended attributes are used to attach arbitrary data to a file or
directory.  This data is not part of the file's contents, but is associated
with it at the filesystem level.  Not all filesystems support EAs; FAT16,
HPFS and JFS do, whereas CDFS and most third-party filesystems do not.

:p.Refer to :link reftype=hd refid=appendixa.Appendix A:elink. for details
on extended attributes and their format.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.file
:pd.The file to which the extended attribute will be written.

:pt.name
:pd.The name of the extended attribute to write.  If the named attribute
already exists, it will be updated with the new value.
:p.This can be any user- or application-defined extended attibute, or one of
the standard system EAs listed in :link reftype=hd refid=appendixa.Appendix
A:elink..
:p.Names starting with a period (.) are reserved for system EAs.  Otherwise
(for user- or application-defined EAs), the name may be any arbitrary string so
long as it contains only filename-legal characters.
:nt.Exercise caution when modifying existing EAs, and especially the standard
system EAs.:ent.

:pt.value
:pd.The new value of the extended attribute.  The value may contain any
arbitrary data, so long as it adheres to the format described in
:link reftype=hd refid=appendixa.Appendix A:elink..
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysPutEA returns 0 if the extended attribute was written successfully;
otherwise, it returns an operating system error code.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* This example will set the .LONGNAME extended attribute (used as the WPS
   * object title) of D&colon.\REPORT01.TXT to 'Report File 1'.
   */
  file    = 'D&colon.\REPORT01.TXT'
  newname = 'Report File 1'

  /* Generate the length bytes.  D2X() is passed a length parameter of 4 in
   * order to generate a two-byte (four character) hexadecimal string; this
   * is then converted to raw byte values with X2C().
   */
  lenbytes = X2C( D2X( LENGTH( newname ), 4 ))

  /* Generate the final EA value (type ASCII).  Note that the order of the
   * length bytes must be reversed.
   */
  eabytes  = X2C('FDFF') || REVERSE( lenbytes ) || newname

  /* Now write the extended attribute.
   */
  CALL SysPutEA file, '.LONGNAME', eabytes
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysqueryclasslist.SysQueryClassList
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysQueryClassList( stem )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Retrieves a complete list of all registered WPS object classes.  The list
is saved to a REXX stem variable.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.stem
:pd.The name of a stem variable in which the list of classes will be saved.
This variable will be returned with the contents&colon.

:dl compact break=none.
:dt.:hp1.stem:ehp1..0
:dd.:hp1.n:ehp1.
:dt.:hp1.stem:ehp1..1
:dd.The first object class (if :hp1.n:ehp1. &gt. 0)
:dt.:hp1.stem:ehp1..2
:dd.The second object class (if :hp1.n:ehp1. &gt. 1)
:dt....
:dd.
:dt.:hp1.stem.n:ehp1.
:dd.The :hp1.n:ehp1.th object class
:edl.
:p.Where :hp1.n:ehp1. is the total number of object classes returned.
:p.Each stem entry takes the format ':hp1.classname DLL:ehp1.', where
:hp1.classname:ehp1. is the registered name of the object class, and
:hp1.DLL:ehp1. is the filename of the DLL which contains the class.
:nt.The DLL filename may or may not include the fully-qualified path.  Typically,
DLLs which are located on the system LIBPATH do not, while all others do.
:ent.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysQueryClassList does not return a meaningful value.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysqueryealist.SysQueryEAList
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysQueryEAList( filename, stem )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Retrieves a complete list of the names of a file's extended attributes.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.filename
:pd.The name of the file or directory whose extended attributes will be
listed.
:pt.stem
:pd.The name of a stem variable in which the list of extended attribute
names will be saved.  This variable will be returned with the contents&colon.
:dl compact break=none.
:dt.:hp1.stem:ehp1..0
:dd.:hp1.n:ehp1.
:dt.:hp1.stem:ehp1..1
:dd.The name of the first extended attribute (if :hp1.n:ehp1. &gt. 0)
:dt.:hp1.stem:ehp1..2
:dd.The name of the second extended attribute (if :hp1.n:ehp1. &gt. 1)
:dt....
:dd.
:dt.:hp1.stem.n:ehp1.
:dd.The name of the :hp1.n:ehp1.th extended attribute
:edl.
:p.Where :hp1.n:ehp1. is the total number of names returned.
:eparml.


:p.
:p.:hp7.Result:ehp7.
:p.SysQueryEAList returns 0 if successful; otherwise, it returns an operating
system error code.


:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* List the EAs of the C&colon.\OS2\BITMAP directory.
   */
  target = 'C&colon.\OS2\BITMAP'
  CALL SysQueryEAList target, 'eas.'

  IF eas.0 == 0 THEN RETURN
  SAY target 'has' eas.0 'extended attributes&colon.'
  DO i = 1 TO eas.0
      SAY ' ' eas.i
  END

  RETURN
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  C&colon.\OS2\BITMAP has 3 extended attributes&colon.
    .LONGNAME
    .ICONPOS
    .CLASSINFO
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysqueryextlibpath.SysQueryExtLIBPATH
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysQueryExtLIBPATH( flag )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the current value of one of the extended LIBPATHs.
:p.An extended LIBPATH is a list of directories to be searched either before
or after the system LIBPATH when locating DLLs.  Refer to the
:link reftype=hd refid=syssetextlibpath.SysSetExtLIBPATH:elink. function for
details.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.flag
:pd.Indicates which extended LIBPATH will be returned.  This must be one of the
following&colon.
:dl compact tsize=4.
:dt.B
:dd.Returns the current BEGINLIBPATH.
:dt.E
:dd.Returns the current ENDLIBPATH.
:edl.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysQueryExtLIBPATH returns the value of the specified extended LIBPATH.
This is a string value which uses the same format as a path environment
variable (i.e. path names separated by semicolons).


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysqueryprocesscodepage.SysQueryProcessCodePage
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysQueryProcessCodePage()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the codepage of the process in which the REXX program is running.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysQueryProcessCodePage returns the codepage number of the current process.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysqueryrexxmacro.SysQueryRexxMacro
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysQueryRexxMacro( name )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the existence of a function in the REXX macrospace.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The name of the function being queried.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysQueryRexxMacro returns the position of the function within the REXX
macrospace, if it exists.  Otherwise, it returns a null string.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysqueryswitchlist.SysQuerySwitchList
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysQuerySwitchList( stem, )&rahead.&lahead. 
                                 , flags                               
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Retrieves the current contents of the Presentation Manager window list.
The list of entries is saved in the specified stem variable.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.stem
:pd.The name of a stem variable in which the list of entries will be be
saved.  This variable will be returned with the contents&colon.
:dl compact break=none.
:dt.:hp1.stem:ehp1..0
:dd.:hp1.n:ehp1.
:dt.:hp1.stem:ehp1..1
:dd.The first window list entry (if :hp1.n:ehp1. &gt. 0)
:dt.:hp1.stem:ehp1..2
:dd.The second window list entry (if :hp1.n:ehp1. &gt. 1)
:dt....
:dd.
:dt.:hp1.stem.n:ehp1.
:dd.The the :hp1.n:ehp1.th window list entry
:edl.
:p.Where :hp1.n:ehp1. is the total number of window list entries returned.
:p.The format of this data depends on the flags specified in the second
parameter.

:pt.flags
:pd.A string containing any or all of the following options&colon.
:dl tsize=4.
:dt.I
:dd.Include invisible entries in the returned list.  Invisible entries are
windows which are not normally displayed in the desktop window list.
:dt.G
:dd.Include 'grayed' entries in the returned list.  Grayed entries are windows
which cannot be switched to (note that they do not actually appear grayed in
the desktop window list).
:dt.N
:dd.Include non-jumpable entries in the returned list.  Non-jumpable entries
are windows which do not appear in the desktop's Alt+Tab jump sequence.
:dt.D
:dd.Use detailed format for list entries.  When specified, each returned entry
will contain the following fields&colon. :hp1.PID SID Visible Jumpable Type
Name:ehp1.
:p.:hp1.PID:ehp1. and :hp1.SID:ehp1. are integer values representing the
window's process ID and session ID, respectively.
:p.:hp1.Visible:ehp1. is the window's visibility flag, which will be one of the
following&colon.
:dl compact tsize=4.
:dt.1
:dd.Invisible
:dt.2
:dd.Grayed
:dt.4
:dd.Visible
:edl.
:p.:hp1.Jumpable:ehp1. is the window's jumpable flag, which will be one of the
following&colon.
:dl compact tsize=4.
:dt.1
:dd.Non-jumpable
:dt.2
:dd.Jumpable
:edl.
:p.:hp1.Type:ehp1. indicates the window's program type, which will be one of
the following&colon.
:dl compact tsize=4.
:dt.0
:dd.Default
:dt.1
:dd.VIO full-screen
:dt.2
:dd.VIO window
:dt.3
:dd.Presentation Manager
:dt.4
:dd.DOS/Windows full-screen
:dt.7
:dd.DOS/Windows window
:edl.
:p.Finally, :hp1.Name:ehp1. is the window title, which is a string with a
maximum length of 60 characters.
:edl.
:p.The default value is the empty string.  Visible and jumpable entries are
always returned.  If the 'D' option is not specified, each stem entry will
contain only the window title.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysQuerySwitchList returns 0.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Show the contents of the window list, including invisible, grayed, and
   * non-jumpable entries.
   */

  CALL SysQuerySwitchList 'sw.', 'IGN'
  IF sw.0 == 0 THEN RETURN
  SAY 'Window list contents&colon.'
  DO i = 1 TO sw.0
      SAY ' ' sw.i
  END

  RETURN
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  Window list contents&colon.
    RUDEMO.CMD
    Mozilla Firefox Start Page - Mozilla Firefox
    WarpCenter
    Desktop
    Workplace Shell
    PMSPOOL.EXE
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysregisterobjectclass.SysRegisterObjectClass
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysRegisterObjectClass( classname, module )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Registers a new object class with the Workplace Shell.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.classname
:pd.The name of the new object class, as defined within the specified module.
:pt.module
:pd.The name of the DLL containing the object class definition.  If this DLL
is not located in the system LIBPATH, it should be specified as a
fully-qualified filename.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysRegisterObjectClass returns the WinRegisterObjectClass API return code.
Possible values are 1 for successful registration, or 0 for failure.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Register the class "MyObject" in DLL E&colon.\EXTENSIONS\MYCLASSES.DLL
   */
  rc = SysRegisterObjectClass('MyObject', 'E&colon.\EXTENSIONS\MYCLASSES.DLL')
  IF rc == 1 THEN
      SAY 'Class "MyObject" was successfully registered.'
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysreleasemutexsem.SysReleaseMutexSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysReleaseMutexSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Releases ownership of a mutex semaphore.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 mutex semaphore, as returned from a previous
call to :link reftype=hd refid=syscreatemutexsem.SysCreateMutexSem:elink..  The
current thread must have ownership of the semaphore (from a previous call to
:link reftype=hd refid=sysrequestmutexsem.SysRequestMutexSem:elink.).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysReleaseMutexSem returns the DosReleaseMutexSem API return code.
Possible values include&colon.
:dl compact tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.288
:dd.Not semaphore owner.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysreorderrexxmacro.SysReorderRexxMacro
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysReorderRexxMacro( name, order )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Moves a function in the REXX macrospace to the beginning or end of the
search order.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.Name of the function in the macrospace to be reordered.
:pt.order
:pd.The function's new position in the macrospace search order.  The acceptable
values are 'B' (before) or 'A' (after).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysReorderRexxMacro returns the RexxReorderMacro API return code.  Possible
values are&colon.
:dl compact tsize=4.
:dt.0
:dd.Success.
:dt.2
:dd.Function was not found in the macrospace
:dt.8
:dd.Invalid search order flag.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysrequestmutexsem.SysRequestMutexSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysRequestMutexSem( handle )&rahead.&lahead. 
                                 , timeout                             
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Requests ownership of a mutex semaphore.
:nt.If the semaphore was created by another process, it must be opened first.
:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 mutex semaphore, as returned from a previous
call to :link reftype=hd refid=syscreatemutexsem.SysCreateMutexSem:elink..
:pt.timeout
:pd.The amount of time, in milliseconds, to wait on the semaphore before
returning.  If not specified, the default is to wait indefinitely.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysRequestMutexSem returns the DosRequestMutexSem API return code.
Possible values include&colon.
:dl compact tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.95
:dd.Interrupt.
:dt.103
:dd.Too many semaphore requests.
:dt.105
:dd.Semaphore owner died.
:dt.640
:dd.Timeout exceeded.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysreseteventsem.SysResetEventSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysResetEventSem( handle )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Resets an event semaphore.  All threads that subsequently call
SysWaitEventSem on that semaphore will be blocked.
:nt.If the semaphore was created by another process, it must be opened first.
:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 event semaphore, as returned from a previous
call to :link reftype=hd refid=syscreateeventsem.SysCreateEventSem:elink..
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysResetEventSem returns the DosResetEventSem API return code.  Possible
values include&colon.
:dl compact tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.300
:dd.Semaphore already reset.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysrmdir.SysRmDir
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysRmDir( dirspec )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Deletes the specified directory.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.dirspec
:pd.The directory to delete.  This directory must not contain any files or
subdirectories, and cannot be the current working directory of any active
process.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysRmDir returns one of the following return codes&colon.
:dl compact tsize=6.
:dt.0
:dd.Success.
:dt.2
:dd.File not found.
:dt.3
:dd.Path not found.
:dt.5
:dd.Access denied.
:dt.16
:dd.Current directory.
:dt.26
:dd.Unsupported filesystem.
:dt.87
:dd.Invalid parameter.
:dt.108
:dd.Drive locked.
:dt.206
:dd.Filename out of range.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssaveobject.SysSaveObject
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSaveObject( name, async )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Instructs the Workplace Shell (WPS) to save the specified object's current
state.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The name of the object to save, which must exist.  This can be specified
as an object ID (e.g. '&lt.WP_DESKTOP&gt.'), or as a fully-qualified filename
if the object exists in the file system (this would apply to files and folders,
but not to program objects and other abstract types).
:pt.async
:pd.Specifies whether or not to save the object asynchronously.  Must be one
of&colon.
:dl compact break=none.
:dt.TRUE
:dd.Save the object asynchronously (lazy-write mode)
:dt.FALSE
:dd.Save the object synchronously (i.e. immediately)
:edl.
:p.Normally, the WPS saves objects asynchronously; that is, on a separate
thread (in so-called "lazy-write" mode).  This has the advantage of not blocking
the main user interface thread while data is being written.  However, it does
mean that updates to an object may not be immediately visible to other
processes.
:p.If you specify 'FALSE' (for synchronous write), the WPS will save the object
state from the main user interface thread before continuing with other
processing.  This will ensure that changes are visible to other processes
immediately.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSaveObject returns the WinSaveObject API return code.  Possible values are
1 if the object was saved successfully, or 0 on failure.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssaverexxmacrospace.SysSaveRexxMacroSpace
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSaveRexxMacroSpace( file )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Saves all functions in the REXX macrospace to a file.  These functions can
be loaded again later using the
:link reftype=hd refid=sysloadrexxmacrospace.SysLoadRexxMacroSpace:elink.
function.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.file
:pd.The file to which the macrospace functions will be saved.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSaveRexxMacroSpace returns the RexxSaveMacroSpace API return code.
Possible values are&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.2
:dd.Macrospace function(s) not found.
:dt.3
:dd.Filename extension required.
:dt.5
:dd.Error accessing file.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssearchpath.SysSearchPath
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSearchPath( path, filename )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Searches for the specified file along the path defined by the specified
environment variable.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.path
:pd.The name of an environment variable containing a path specification.

:p.This may be one of the standard system paths (such as 'PATH' or 'DPATH'),
or any other environment variable that contains a valid path specification
(a list of one or more path names separated by semicolons).

:pt.filename
:pd.The name of the file to search for.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSearchPath returns the fully-qualified name of the first instance
of the file that was found along the specified path.  If the file was not
found, an empty string is returned.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Search the system BOOKSHELF path for REXX.INF.
   */
  book = SysSearchPath('BOOKSHELF', 'REXX.INF')
  IF book == '' THEN
      SAY 'REXX.INF was not found on the current BOOKSHELF path.'
  ELSE
      SAY 'REXX.INF is located at&colon.' book
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssetextlibpath.SysSetExtLIBPATH
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetExtLIBPATH(, flag )&rahead.&lahead. 
                        path                                           
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sets the current value of one of the extended LIBPATHs.
:p.An extended LIBPATH is a list of directories to be searched either before
or after the system LIBPATH when locating DLLs.  The OS/2 operating system
defines two extended LIBPATHs&colon.
:dl compact tsize=18.
:dt.BEGINLIBPATH
:dd.A list of directories to search before the system LIBPATH.
:dt.ENDLIBPATH
:dd.A list of directories to search after the system LIBPATH.
:edl.

:p.An extended LIBPATH behaves similarly to an environment variable, in that
it applies only to the current process and its children.  Under the standard
OS/2 command processor (CMD.EXE), it may also be set using environment-variable
syntax.  Technically, however, it is not an environment variable but a special
system parameter.

:p.The extended LIBPATHs provide a useful means of overriding the operating
system's normal DLL search order, on a per-process basis.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.path
:pd.The new value of the extended LIBPATH.  This is a path specification
(a list of one or more path names separated by semicolons) of up to 1024
characters in length.
:p.The path specification may contain the following strings, which are
treated as substitution variables&colon.
:dl compact tsize=20.
:dt.%BEGINLIBPATH%
:dd.The current value of the BEGINLIBPATH.
:dt.%ENDLIBPATH%
:dd.The current value of the ENDLIBPATH.
:edl.
:p.The corresponding value will be substituted into the new extended
LIBPATH.  Note that the final value of the extended LIBPATH after
substitution may not exceed 1024 characters (or else SysSetExtLIBPATH
will return with error code 87).
:p.If not specified (or if an empty string is given), the current value
of the specified extended LIBPATH will be deleted.

:pt.flag
:pd.Indicates which extended LIBPATH will be set.  This must be one of the
following&colon.
:dl compact tsize=4.
:dt.B
:dd.Sets the current BEGINLIBPATH.
:dt.E
:dd.Sets the current ENDLIBPATH.
:edl.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetExtLIBPATH returns the operating system return code.
Possible values include&colon.
:dl compact break=none tsize=5.
:dt.0
:dd.Success.
:dt.8
:dd.Not enough memory.
:dt.87
:dd.Invalid parameter.
:edl.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Delete the current BEGINLIBPATH.
   */
  CALL SysSetExtLIBPATH, 'B'

  /* Add F&colon.\EXTENDED to the ENDLIBPATH.
   */
  rc = SysSetExtLIBPATH('F&colon.\EXTENDED;%ENDLIBPATH%', 'E')
  SAY 'SysSetExtLIBPATH returned&colon.' rc
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssetfiledatetime.SysSetFileDateTime
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetFileDateTime( filename &rahead. 
                                                                           
 &rahead.)&rahead.&lahead. 
     ,                              
          newdate   ,                                
                             newtime                                   
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sets the specified file's date/time attribute for most recent write
(the "last modified" timestamp).

:p.The date, the time, or both, may be set to an arbitrary value.  If only one
of the two is specified, the other is left unchanged.  However, if neither a
date nor a time is specified, the file's timestamp is set to the current date
and time (this is known as a "touch" operation).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.filename
:pd.The name of the file whose date/time attribute is to be changed.  This
file must be available for writing; that is, it cannot be locked for exclusive
writes by another process.

:p.Under OS/2 and Windows NT, this parameter may be the name of a directory.
However, this is not allowed under Windows 95/98, AIX, or Linux.

:pt.newdate
:pd.The new date value to be set, in :hp2.YYYY-MM-DD:ehp2. format.

:pt.newtime
:pd.The new time value to be set, in 24-hour :hp2.hh&colon.mm&colon.ss:ehp2.
format.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetFileDateTime returns one of the following values&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.Success.
:dt.-1
:dd.Failed to update attribute.
:edl.

:p.
:p.:hp7.Examples:ehp7.
:xmp.
  /* Set FILE1.TXT to the current date and time (touch).
   */
  CALL SysSetFileDateTime 'FILE1.TXT'

  /* Set the date on FILE2.TXT but leave the time unchanged.
   */
  CALL SysSetFileDateTime 'FILE2.TXT', '2006-05-11'

  /* Set the time on FILE3.TXT but leave the date unchanged.
   */
  CALL SysSetFileDateTime 'FILE3.TXT',, '18&colon.30&colon.00'

  /* Set both date and time on FILE4.TXT.
   */
  CALL SysSetFileDateTime 'FILE4.TXT', '2003-07-24', '07&colon.43&colon.20'
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssetfilehandle.SysSetFileHandle
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetFileHandle( number )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sets the maximum number of file handles available to the current process.
:p.By default, OS/2 makes 50 file handles available to each process.
SysSetFileHandle can be used to increase this number, as long as the system
limit has not been reached.
:p.All open file handles are preserved when this function is called.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.number
:pd.The total number of file handles to be made available.  This number
may not be less than the number of file handles already available to the
current process (or else SysSetFileHandle will return with error code 87).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetFileHandle returns the DosSetMaxFH API return code.
Possible values are&colon.
:dl compact break=none tsize=5.
:dt.0
:dd.Success.
:dt.8
:dd.Not enough memory.
:dt.87
:dd.Invalid parameter.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysseticon.SysSetIcon
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetIcon( filename, iconfilename )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sets the specified file's icon, using the icon data contained in the
specified OS/2 icon file.
:p.The icon image is read from the icon file, and written to the target
file's .ICON extended attribute (EA).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.filename
:pd.The name of the target file whose icon is to be set.

:pt.iconfilename
:pd.The name of the OS/2 icon file (.ICO) which contains the icon data to be
used.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetIcon returns the WinSetFileIcon API return code.  Possible values
are 1 if the icon was set successfully, or 0 otherwise.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Set the icon for D&colon.\APP.EXE from the icon file E&colon.\ICONS\PROGRAM.ICO.
   */
  file = 'D&colon.\APP.EXE'
  icon = 'E&colon.\ICONS\PROGRAM.ICO'
  IF SysSetIcon( file, icon ) == 1 THEN
      SAY 'Icon for' file 'was set successfully.'
  ELSE
      SAY 'Icon for' file 'could not be set.'
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssetobjectdata.SysSetObjectData
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetObjectData( name, setup )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Changes the settings of the specified Workplace Shell object.  This function
can also be used to open the object in a particular view.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The name of the object whose settings are to be changed, which must
exist.  This can be specified as an object ID (e.g. '&lt.WP_DESKTOP&gt.'), or
as a fully-qualified filename if the object exists in the file system (this
would apply to files and folders, but not to program objects and other abstract
types).

:pt.setup
:pd.A Workplace Shell (WPS) setup string.
:p.Refer to :link reftype=hd refid=appendixb.Appendix B:elink. for a detailed
description of setup strings and their format.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetObjectData returns the WinSetObjectData API return code.  Possible
values are 1 if the object was updated successfully, or 0 on failure.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Change the title and icon of the object '&lt.My_Object&gt.'.
   */
  IF SysSetObjectData('&lt.My_Object&gt.',,
                      'TITLE=My Object;ICONFILE=F&colon.\ICONS\MY.ICO;') THEN
      SAY 'Object settings updated successfully.'

  /* Open the object's default view.
   */
  CALL SysSetObjectData '&lt.My_Object&gt.', 'OPEN=DEFAULT;'
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssetpriority.SysSetPriority
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetPriority( class, delta )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sets the priority of the current process.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.class
:pd.The new priority class of the process.  Possible values are&colon.
:dl compact break=none tsize=4.
:dt.0
:dd.No change (leave as-is).
:dt.1
:dd.Idle-time priority.
:dt.2
:dd.Regular priority.
:dt.3
:dd.Time-critical priority.
:dt.4
:dd.Foreground server (fixed high) priority.
:edl.

:pt.delta
:pd.The change to apply to the process's current base priority level.
This value must fall within the range of -31 to +31.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetPriority returns the DosSetPriority API return code.  Possible values
are&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.303
:dd.Invalid process ID.
:dt.304
:dd.Invalid priority delta.
:dt.305
:dd.Not descendant.
:dt.307
:dd.Invalid priority class.
:dt.308
:dd.Invalid scope.
:dt.309
:dd.Invalid thread ID.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssetprocesscodepage.SysSetProcessCodePage
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSetProcessCodePage( codepage )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sets the codepage for the current process.
:p.This function sets the process codepage, which also determines the codepage
of any printer opened by the same process after the function is called (but
not before).  The new process codepage will also be inherited by any child
processes.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.codepage
:pd.The new process codepage.  This codepage must be one of the codepages
(up to two) specified in the system CODEPAGE setting (defined in CONFIG.SYS).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSetProcessCodePage returns the DosSetProcessCp API return code.
Possible values are&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.472
:dd.Invalid code page.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysshutdownsystem.SysShutDownSystem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysShutDownSystem()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Immediately shuts down the operating system.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysShutDownSystem returns 1 on successful shutdown, or 0 on failure.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssleep.SysSleep
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSleep( secs )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Pauses the currently-running REXX program or thread for the specified
interval.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.secs
:pd.The pause interval, in seconds.  Recent versions of RexxUtil accept
fractional values.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSleep returns 0.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysstemcopy.SysStemCopy
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysStemCopy( source, target &rahead. 
                                                                           
 &rahead.)&rahead.&lahead. 
     ,      
          sidx  ,       
                         tidx  ,        
                                        count  ,         
                                                        mode           
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Copies elements from one array-type stem variable to another.
:p.Both the source and target stems must use REXX array-index notation.
Specifically, :hp1.stem:ehp1..0 must contain the number of elements, and all
other elements must be numbered consecutively from :hp1.stem:ehp1..1 to
:hp1.stem.n:ehp1. (where :hp1.n:ehp1. is the value of :hp1.stem:ehp1..0).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.source
:pd.The name of the stem to copy elements from.
:pt.target
:pd.The name of the stem to copy elements into.
:pt.sidx
:pd.The index in the source stem of the first element to copy.  The default
value is 1.
:pt.tidx
:pd.The index in the target stem where the copied elements will be inserted.  The
default value is 1.
:pt.count
:pd.The number of elements to copy.  The default is to copy all elements following
sidx.
:pt.mode
:pd.Controls the behaviour of the copy operation.  Must be one of the following
values&colon.
:dl compact tsize=4 break=none.
:dt.I
:dd.Insert mode (existing elements in the target stem are shifted up).
:dt.O
:dd.Overwrite mode (existing elements in the target stem are overwritten).
:edl.
:p.Overwrite mode is the default behaviour.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysStemCopy returns 0 if the copy succeeded, or -1 if it failed.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Source stem (4 elements)&colon.
   */
  data.0 = 4
  data.1 = 'Alice'
  data.2 = 'Wally'
  data.3 = 'Ted'
  data.4 = 'Tina'

  /* Target stem, initial contents&colon.
   */
  newdata.0 = 2
  newdata.1 = 'Carol'
  newdata.2 = 'Bob'

  DO i = 1 TO newdata.0
      SAY newdata.i
  END
  SAY

  /* Add 'data.3' and 'data.4' to 'newdata.', starting at target index 3.
   */
  CALL SysStemCopy 'data.', 'newdata.', 3, 3, 2
  DO i = 1 TO newdata.0
      SAY newdata.i
  END
  SAY

  /* Insert 'data.1' and 'data.2' into 'newdata.', starting at target index 1.
   */
  CALL SysStemCopy 'data.', 'newdata.', 1, 1, 2, 'I'
  DO i = 1 TO newdata.0
      SAY newdata.i
  END
:exmp.
:p.The following is the output from this example&colon.
:xmp.
  Carol
  Bob

  Carol
  Bob
  Ted
  Tina

  Alice
  Wally
  Carol
  Bob
  Ted
  Tina
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysstemdelete.SysStemDelete
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysStemDelete( stem, index )&rahead.&lahead. 
                                 , count                               
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Deletes one or more elements from an array-type stem variable.  All
subsequent elements in the stem will be shifted down to fill the vacated index
positions.
:p.The stem must use REXX array-index notation.  Specifically, :hp1.stem:ehp1..0
must contain the number of elements, and all other elements must be numbered
consecutively from :hp1.stem:ehp1..1 to :hp1.stem.n:ehp1. (where :hp1.n:ehp1.
is the value of :hp1.stem:ehp1..0).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.stem
:pd.The name of the stem from which the element will be deleted.
:pt.index
:pd.The index position of the first element to delete.
:pt.count
:pd.The number of elements to delete.  The default is 1.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysStemDelete returns 0 if the delete operation succeeded, or -1 if it
failed.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syssteminsert.SysStemInsert
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysStemInsert( stem, index, value )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Inserts a new element into an array-type stem variable.  All subsequent
elements in the stem will be shifted up by one.
:p.The stem must use REXX array-index notation.  Specifically, :hp1.stem:ehp1..0
must contain the number of elements, and all other elements must be numbered
consecutively from :hp1.stem:ehp1..1 to :hp1.stem.n:ehp1. (where :hp1.n:ehp1.
is the value of :hp1.stem:ehp1..0).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.stem
:pd.The name of the stem into which the element will be inserted.
:pt.index
:pd.The index position at which the element will be inserted.
:pt.value
:pd.The new element value to insert.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysStemInsert returns 0 if the insert operation succeeded, or -1 if it
failed.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysstemsort.SysStemSort
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysStemSort( stem &rahead. 
                                                                           
 &rahead.&rahead. 
     ,&rahead. 
          order   ,&rahead. 
                           case   ,&rahead. 
                                           start   ,&rahead. 
                                                            end        
                                                                           
 &rahead.)&rahead.&lahead. 
 &rahead.                   
 &rahead.                     
 &rahead.                       
 &rahead.                         
     ,                           
          firstchar   ,                             
                               lastchar                                
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Sorts elements within an array-type stem variable.
:p.All elements, or a specified range of elements, can be sorted.  Options
include whether to sort in ascending or descending order, and whether or not
case-sensitivity will be used when comparing element values.  The sort key
used for comparison can be the entire value of each element, or a sub-string
defined by character positions within each value.
:p.The final order of elements with equal value (as determined by the sort
key) cannot be predicted, due to the quicksort algorithm used.
:p.The sort is performed according to dictionary rules; that is, number values
will be sorted alphabetically, and not by magnitude.
:p.The stem must use REXX array-index notation.  Specifically, :hp1.stem:ehp1..0
must contain the number of elements, and all other elements must be numbered
consecutively from :hp1.stem:ehp1..1 to :hp1.stem.n:ehp1. (where :hp1.n:ehp1.
is the value of :hp1.stem:ehp1..0).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.stem
:pd.The name of the stem to be sorted.

:pt.order
:pd.Specifies the sort order to use.  Possible values are&colon.
:dl compact break=none tsize=4.
:dt.A
:dd.Sort elements in ascending order of value.
:dt.D
:dd.Sort elements in descending order of value.
:edl.
:p.The default behaviour is to sort values in ascending order.

:pt.case
:pd.Specifies whether or not element values will be compared case-sensitively
when sorting.  Possible values are&colon.
:dl compact break=none tsize=4.
:dt.C
:dd.Use case-sensitivity when comparing values.
:dt.I
:dd.Ignore case when comparing values.
:edl.
:p.The default behaviour is to use case-sensitivity.

:pt.start
:pd.The starting index of the range of elements to be sorted.  The default
value is 1 (the first element in the stem).

:pt.end
:pd.The ending index of the range of elements to be sorted.  The default value
is the last element in the stem.

:pt.firstchar
:pd.The starting character position of the sort key.  The sort key is the
character string within each element that will be used for comparison.  The
default value is 1 (the first character in each element).

:pt.lastchar
:pd.The ending character position of the sort key.  The default value is the
last character in each element.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysStemSort returns 0 if the sort operation succeeded, or -1 if it
failed.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  names.0  = 10
  names.1  = 'Irina'
  names.2  = 'Evgeni'
  names.3  = 'Shizuka'
  names.4  = 'Jeffrey'
  names.5  = 'Sasha'
  names.6  = 'Evan'
  names.7  = 'Stephane'
  names.8  = 'Brian'
  names.9  = 'Carolina'
  names.10 = 'Mira'

  /* Sort the entire stem in ascending order, ignoring case.
   */
  CALL SysStemSort 'names.',, 'I'
  DO i = 1 TO names.0
      SAY names.i
  END
  SAY

  /* Now sort the entire stem in descending order, using characters 2 through 4
   * of each element as the sort key.
   */
  CALL SysStemSort 'names.','D',,,, 2, 4
  DO i = 1 TO names.0
      SAY names.i
  END
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  Brian
  Carolina
  Evan
  Evgeni
  Irina
  Jeffrey
  Mira
  Sasha
  Shizuka
  Stephane

  Evgeni
  Evan
  Stephane
  Irina
  Brian
  Mira
  Shizuka
  Jeffrey
  Sasha
  Carolina
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysswitchsession.SysSwitchSession
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysSwitchSession( name )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Switches the active (foreground) session to the specified program.  The
specified program must already be running, and must appear in the Presentation
Manager window list (see
:link reftype=hd refid=sysqueryswitchlist.SysQuerySwitchList:elink.).

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The title of the program to switch to, as it appears in the window list.
The program (along with any child windows) will move to the front of the screen
and receive the input focus.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysSwitchSession returns the WinSwitchToProgram API return code.  Possible
values include&colon.
:dl compact break=none tsize=7.
:dt.0
:dd.Success.
:dt.4357
:dd.Invalid window title.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=systempfilename.SysTempFileName
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysTempFileName( template )&rahead.&lahead. 
                                , filter                               
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Generates a random, unique filename according to the specified template.
This filename may be used to create a temporary file or directory.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.template
:pd.Specifies both the parent directory and the naming pattern of the filename
to be generated.  This must be a valid file or directory specification which
includes between one and five filter characters.  SysTempFileName will replace
the filter characters with random numeric values, such that the resulting
filename is unique within the parent directory.
:p.The filter characters are indicated using the character specified in the
:hp1.filter:ehp1. parameter.

:pt.filter
:pd.The filter character used in the :hp1.template:ehp1. paremeter.  If not
specified, the default filter character is '?'.
:p.Each filter character is replaced with a random number.  If the resulting
filename is the same as that of an existing file or directory, each replacement
value is incremented until either a unique filename is generated, or all
possibilities are exhausted.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysTempFileName returns the generated filename.  If an error occurs, or if
a unique filename cannot be generated from the specified template, the empty
string ('') is returned.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  tmpdir = VALUE('TMP',,'OS2ENVIRONMENT')
  file1 = SysTempFileName( tmpdir'\DATA??.???')
  file2 = SysTempFileName( tmpdir'\###TMP', '#')
  SAY file1
  SAY file2
:exmp.
:p.The following is a sample of output from the above example&colon.
:xmp.
  C&colon.\TCPIP\TMP\DATA59.916
  C&colon.\TCPIP\TMP\658TMP
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=systextscreenread.SysTextScreenRead
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysTextScreenRead( row, column )&rahead.&lahead. 
                                     , len                             
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Reads characters from the specified position on screen within the current
text (window or full-screen) session.

:nt.Only character values are read.  Colour attributes (if any) are ignored,
and will be lost if and when the text is subsequently printed back to the
screen.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.row
:pd.The column number at which to start reading characters.

:pt.column
:pd.The row number at which to start reading characters.

:pt.len
:pd.The number of characters to read from the specified starting position.
If not specified, the default behaviour is to read all remaining characters
to the end of the screen.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysTextScreenRead returns a string consisting of the characters read, in
sequence.
.* --> The IBM documentation says the following is true.  However, I've had
.*     reports from testers saying it is not.  This must be tested!
.* This will include carriage return and newline characters, if the text being read spans multiple lines on screen.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Read 40 columns starting from column 40 on line 10.
   */
  line = SysTextScreenRead( 10, 40, 40 )

  /* Read the entire screen.
   */
  all = SysTextScreenRead( 0, 0 )
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=systextscreensize.SysTextScreenSize
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysTextScreenSize()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the screen size, in rows and columns, of the current text (window
or full-screen) session.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysTextScreenSize returns a string of the form&colon.
:xmp.    rows cols
:exmp.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Query the size of the current window or full-screen session.
   */
  PARSE VALUE SysTextScreenSize() with rows cols
  SAY 'The current session has' cols 'columns and' rows 'rows.'
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  The current session has 80 columns and 25 rows.
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysutilversion.SysUtilVersion
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysUtilVersion()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the current version of the RexxUtil library.

:nt.You should not rely exclusively on SysUtilVersion to determine the
current RexxUtil version, as this function was not included in earlier
versions of the library.  See below for an example of suggested usage.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysUtilVersion returns a string of the form&colon.
:xmp.    x.yy
:exmp.
where :hp1.x:ehp1. is the major version number, and :hp1.yy:ehp1. is the
modification (refresh) level.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Queries the current RexxUtil version, first checking to see if the
   * SysUtilVersion function is available.
   */
  CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  CALL SysLoadFuncs
  IF RxFuncQuery('SysUtilVersion') \= 0 THEN
      SAY 'The RexxUtil library is out of date (exact version could not be determined).'
  ELSE
      SAY 'The current RexxUtil version is&colon.' SysUtilVersion()
:exmp.
:p.The following is a sample of output from this example&colon.
:xmp.
  The current RexxUtil version is&colon. 2.00
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=sysversion.SysVersion
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysVersion()&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Queries the current operating system and its version.
:p.Unlike the :link reftype=hd refid=sysos2ver.SysOS2Ver:elink. function,
SysVersion is platform-neutral, and can be used to identify the environment
under which the REXX program is running.

:p.
:p.:hp7.Parameters:ehp7.
:p.None.

:p.
:p.:hp7.Result:ehp7.
:p.SysVersion returns a string of the form&colon.
:xmp.    OS version
:exmp.
where :hp1.OS:ehp1. is the operating system, and :hp1.version:ehp1. is the
current operating system version.
:nt.The version number reported under OS/2 has the same format as described
under the :link reftype=hd refid=sysos2ver.SysOS2Ver:elink. function.:ent.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Query the operating system and its version.
   */
  SAY 'Currently running under&colon.' SysVersion()
:exmp.
:p.The following are samples of output from this example under various
operating systems.
:p.OS/2 4.5:hp1.x:ehp1.&colon.
:xmp.  Currently running under&colon. OS/2 2.45
:exmp.
:p.Windows 2000&colon.
:xmp.  Currently running under&colon. WindowsNT 5.00
:exmp.
:p.Linux kernel 2.6.12&colon.
:xmp.  Currently running under&colon. Linux 2.6.12
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syswaiteventsem.SysWaitEventSem
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysWaitEventSem( handle )&rahead.&lahead. 
                              , timeout                                
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Waits for an event semaphore to be posted.
:nt.If the semaphore was created by another process, it must be opened first.
:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.handle
:pd.The handle of an existing OS/2 event semaphore, as returned from a
previous call to :link reftype=hd refid=syscreateeventsem.SysCreateEventSem:elink..
:pt.timeout
:pd.The amount of time, in milliseconds, to wait on the semaphore before
returning.  If not specified, the default behaviour is to wait indefinitely.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysWaitEventSem returns the DosWaitEventSem API return code.  Possible values
include&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success.
:dt.6
:dd.Invalid handle.
:dt.8
:dd.Not enough memory.
:dt.95
:dd.Interrupt.
:dt.640
:dd.Timeout exceeded.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syswaitforshell.SysWaitForShell
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysWaitForShell( event )&rahead.&lahead. 
                             , query                                   
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Checks for the specified Workplace Shell initialization event, and optionally
blocks until that event has occurred.
:nt.This function is only meaningful under OS/2 version 4.0 and later.  Under
earlier versions it will return immediately with a return value of 1.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.event
:pd.The initialization event to check for.  Allowable values are&colon.
:dl compact tsize=20.
:dt.DESKTOPCREATED
:dd.The WPS desktop window has been created.
:dt.DESKTOPOPENED
:dd.The WPS desktop window has been opened.
:dt.DESKTOPPOPULATED
:dd.The WPS desktop window has been populated with all its objects.
:edl.

:pt.query
:pd.Optional flag indicating that the status of the specified event is to be
be queried only.  This parameter must take the value "QUERY".
:p.If this parameter is specified, SysWaitForShell will return immediately with
the appropriate value.  Otherwise, the function will not return until the
specified event has occurred.
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysWaitForShell returns the WinWaitForShell API return code.  Possible values
are 1 if the specified event has occurred, or 0 if it has not occurred.  (A
return value of 0 is only possible if the query flag was specified.)

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Wait until the desktop is populated, then open the System Setup folder in
   * icon view.
   */
  CALL SysWaitForShell 'DESKTOPPOPULATED'
  CALL SysOpenObject '<WP_CONFIG>', 'ICON', 'TRUE'
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syswaitnamedpipe.SysWaitNamedPipe
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysWaitNamedPipe( name )&rahead.&lahead. 
                             , timeout                                 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Waits for a named pipe to become available.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.name
:pd.The name of the pipe to wait for.  This is a string of the form
:hp2.\PIPE\:ehp2.:hp3.pipename:ehp3..

:pt.timeout
:pd.The amount of time to wait, in milliseconds.  If this parameter is 0 or
is not specified, the pipe's default timeout value will be used.  A value of
-1 will cause SysWaitNamedPipe to wait indefinitely (until the pipe becomes
available).
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysWaitNamedPipe returns the DosWaitNPipe API return code.  Possible values
include&colon.
:dl compact break=none tsize=6.
:dt.0
:dd.Success; the named pipe is now available.
:dt.2
:dd.The named pipe was not found.
:dt.95
:dd.Interrupted system call
:dt.121
:dd.Semaphore timeout.
:dt.230
:dd.Invalid operation.
:dt.231
:dd.Operation timed out before the named pipe became available.
:edl.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Try to open the pipe \PIPE\npipe01 for reading.
   */
  npipe = '\PIPE\npipe01'
  inbuf = ''
  PARSE VALUE STREAM( npipe, 'C', 'OPEN READ') WITH state '&colon.' rc

  /* If the pipe is busy, block until it becomes available.
   */
  IF state \= 'READY' THEN DO
      IF rc == 231 THEN CALL SysWaitNamedPipe( pipe, -1 )
      ELSE DO
          SAY 'Unexpected error opening pipe&colon.' state
          RETURN rc
      END
  END

  /* Now read data from the pipe.
   */
  DO WHILE CHARS( npipe ) > 0
      inbuf = inbuf || CHARIN( npipe )
  END
  SAY inbuf
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=syswildcard.SysWildCard
:p.:hp7.Syntax:ehp7.
:cgraphic.
Ŀ
                                                                           
 &rahead.&rahead.SysWildCard( source, wildcard )&rahead.&lahead. 
                                                                           

:ecgraphic.

:p.:hp7.Description:ehp7.
:p.Transforms a filename string using the specified wildcard pattern.
:nt.This function simply transforms strings according to filename rules
(using the DosEditName API).  It does not actually perform any file
operations.:ent.

:p.
:p.:hp7.Parameters:ehp7.
:parml break=fit.
:pt.source
:pd.Filename string to be transformed.  An asterisk ('*') may be used to
indicate zero or more indeterminate characters, not including the backslash
('\').  A question mark ('?') may be used to indicate exactly one indeterminate
character, not including the period ('.') or the backslash ('\').
:p.If the filename string contains no period ('.'), one is implicitly
appended to the end of the string.

:pt.wildcard
:pd.Wildcard pattern used to transform the source string.  An asterisk ('*')
will copy characters from the source string until a character is found that
matches the character following the asterisk in the wildcard pattern.  A
question mark ('?') will copy any single character other than a period ('.').
:eparml.

:p.
:p.:hp7.Result:ehp7.
:p.SysWildCard returns the transformed string.  If an error occurs, a null
string ('') is returned.

:p.
:p.:hp7.Example:ehp7.
:xmp.
  /* Search the current directory for all files with the extension 'ptr'
   * and rename them to have the extension 'ico'.
   */
  CALL SysFileTree '*.ptr', 'found.', 'FO'
  DO i = 1 TO found.0
      newname = SysWildCard( FILESPEC('NAME', found.i ), '*.ico')
      'move' found.i newname
  END
:exmp.


.******************************************************************************
:h1 x=left y=bottom width=100% height=100% id=appendixa.Appendix A&colon. Extended Attributes
:p.Every extended attribute (EA) consists of a name and a value.
:p.The total size of a file's extended attributes may not exceed 64kB; this is
also the maximum size of a single EA.

:p.
:p.:hp7.Attribute Names:ehp7.
:p.EA names starting with a period (.) are reserved for extended attributes
which are defined by the operating system.  These include&colon.
:ul compact.
:li..ASSOCTABLE
:li..CLASSINFO
:li..CODEPAGE
:li..COMMENTS
:li..HISTORY
:li..ICON
:li..ICON1
:li..ICONPOS
:li..KEYPHRASES
:li..LONGNAME
:li..PREVNAME
:li..SUBJECT
:li..TYPE
:li..VERSION
:eul.
:p.These are described in detail in the :hp1.Control Program Programming Guide
and Reference:ehp1., which is included in the IBM Developer's Toolkit.

:p.
:p.:hp7.Format:ehp7.
:p.The first two bytes of an EA's value always indicate the type of data, which
in turn determines how the following bytes must be interpreted.  Standard values
are &colon.
:dl.
:dt.FEFF
:dd.Binary data.  The following two bytes form a WORD value indicating the
length of the data, and the remaining bytes contain the actual data.
:dt.FDFF
:dd.ASCII text.  The following two bytes form a WORD value indicating the
length of the data, and the remaining bytes contain the actual data.
:dt.FBFF
:dd.Bitmap data.  The following two bytes form a WORD value indicating the
length of the data, and the remaining bytes contain the actual data.
:dt.FAFF
:dd.Metafile data.  The following two bytes form a WORD value indicating the
length of the data, and the remaining bytes contain the actual data.
:dt.F9FF
:dd.Icon data.  The following two bytes form a WORD value indicating the
length of the data, and the remaining bytes contain the actual data.
:dt.EEFF
:dd.ASCII name of another EA whose value is to be included in this one.  The
following two bytes form a WORD value indicating the length of the data, and
the remaining bytes contain the actual data.
:dt.DFFF
:dd.A list of values with differing data types.  The following two bytes
form a WORD value indicating the codepage of the remaining data.  The subsequent
two bytes form a WORD value indicating the number of values in the list.  The
remaining bytes comprise the list of data items, each consisting of a two-byte
data type, followed by a two-byte WORD indicating data length, followed by the
actual data.
:dt.DEFF
:dd.A list of values with the same data type.  The following two bytes
form a WORD value indicating the codepage of the remaining data.  The
subsequent two bytes form a WORD value indicating the number of values in
the list.  The next two bytes indicate the EA data type of the items in the
list.  The remaining bytes comprise the list of data items, each consisting of
a two-byte WORD indicating data length, followed by the actual data.
:dt.DDFF
:dd.ASN.1 (Abstract Syntax Notation ISO format) field data.
:edl.
:p.Specific applications may use their own custom data formats.
:nt.References to WORD values in the list above indicate a pair of bytes
which combine in reverse (right-to-left) order to form a single number.  For
instance, the byte sequence '5001' indicates the hexadecimal value 0x0150
(decimal 336).  REXX, of course, represents all numbers in human-readable
left-to-right order; therefore, when converting a number to a WORD value (or
vice versa), you must remember to reverse the byte order.  Refer to the examples
shown under the :link reftype=hd refid=sysputea.SysPutEA:elink. and
:link reftype=hd refid=sysgetea.SysGetEA:elink. functions for an
illustration.:ent.

:p.
:p.:hp7.Additional Information:ehp7.
:p.If you have the IBM Developer's Toolkit installed, you can click on the
following links for more information&colon.
:ul compact.
:li.:link reftype=launch object='view.exe' data='CP1.INF+CP2.INF+CP3.INF Standard Extended Attributes'.Standard
system extended attributes:elink.
:li.:link reftype=launch object='view.exe' data='CP1.INF+CP2.INF+CP3.INF Extended Attribute Data Type Conventions'.Format
of extended attributes:elink.
:eul.


.******************************************************************************
:h1 x=left y=bottom width=100% height=100% id=appendixb.Appendix B&colon. WPS Setup Strings
:p.A Workplace Shell setup string consists of one or more
:hp1.keyname:ehp1.=:hp1.value:ehp1. pairs, separated by semicolons.

:p.If a particular keyname supports multiple values, those values are separated
by commas.  A literal comma can be specified with &osq.:hp2.^,:ehp2.&csq., a
literal semicolon with &osq.:hp2.^;:ehp2.&csq., and a newline with
&osq.:hp2.^:ehp2.&csq..

:p.The specific keynames and values supported are dependent on the WPS
object class of the object being updated.  Refer to the following sections for
details&colon.

:ul compact.
:li.:link reftype=hd refid=wpobject.Keys supported by all objects (WPObject):elink..
:li.:link reftype=hd refid=wpfolder.Keys supported by folder objects (WPFolder):elink..
:li.:link reftype=hd refid=wpprogram.Keys supported by program objects (WPProgram):elink..
:li.:link reftype=hd refid=wpprogramfile.Keys supported by executable file objects (WPProgramFile):elink..
:li.:link reftype=hd refid=wpshadow.Keys supported by shadow objects (WPShadow):elink..
:li.:link reftype=hd refid=wpprinter.Keys supported by printer objects (WPPrinter):elink..
:eul.

:p.Additional keynames supported by other standard object classes are documented
in the :hp1.Workplace Shell Programming Reference:ehp1., which is included in
the IBM Developer's Toolkit.

:p.Other applications may create third-party object classes which support their
own specific keynames.  These should be described in the application
documentation.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=wpobject.Setup string keys supported by all objects
:p.All objects support the following keynames (defined by the WPObject class)&colon.

:dl break=fit tsize=20.
:dt.CCVIEW
:dd.Sets the 'concurrent view' property, which controls whether or not
multiple instances of the object may be open simultaneously.  Allowable
values are&colon.
:dl compact break=none.
:dt.DEFAULT
:dd.The system default will be used.
:dt.YES
:dd.A new instance of the object will be created whenever the object is opened.
:dt.NO
:dd.An existing instance of the object will be used whenever the object is opened.
:edl.

:dt.DEFAULTVIEW
:dd.The view of the object to open by default when selected.  This may be the
ID (0-9) of a user-defined view, or any of the values listed under the OPEN
keyname (below).

:dt.HELPLIBRARY
:dd.The filename of the help library to be associated with the object.

:dt.HELPPANEL
:dd.The ID of the default help panel for the object.

:dt.HIDEBUTTON
:dd.Controls whether open views of the object use a 'hide' button in
the frame controls (as opposed to a 'minimize' button).  The default
behaviour (which cannot be specified here) is to use the system
setting.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object's views will have a 'hide' button.
:dt.NO
:dd.The object's views will have a 'minimize' button.
:edl.

:dt.ICONFILE
:dd.The filename of the icon to associate with the object, when an OS/2
icon file is to be used for the object's icon.

:dt.ICONPOS
:dd.The initial position of the object's icon within its parent folder.
The value is specified as ':hp1.x,y:ehp1.', where :hp1.x:ehp1. and
:hp1.y:ehp1. are horizontal and vertical percentages, respectively, of
the parent folder's size, measured from the bottom left corner.

:dt.ICONRESOURCE
:dd.The resource of the icon to associate with the object, when a
Presentation Manager icon resource is to be used for the object's icon.
The value is specified as ':hp1.id,module:ehp1.', where :hp1.module:ehp1.
is the DLL file containing the icon resource, and :hp1.id:ehp1. is the
resource ID of the icon with the DLL.

:dt.LOCKEDINPLACE
:dd.Controls whether the object's icon is locked in position (under its
parent folder's icon view) so that it cannot be moved.  Allowable values
are&colon.
:dl compact break=none.
:dt.YES
:dd.The object's icon is locked in place and cannot be moved.
:dt.NO
:dd.The object's icon can be moved freely (this is the default).
:edl.

:dt.MENUITEMSELECTED
:dd.Activates the specified menu item from the object's context menu.
The value is specified as a numeric :link reftype=fn refid=wpmenuid.menu
item ID:elink..

:dt.MENUS
:dd.Sets the object's context menu style.  Allowable values are&colon.
:dl compact break=none.
:dt.SHORT
:dd.Short menus.
:dt.LONG
:dd.Long menus (this is the default).
:edl.

:dt.MINWIN
:dd.Controls the behaviour of the 'minimize' or 'hide' button within the
object's views.  The default behaviour (which cannot be specified here)
is to use the system setting.  Allowable values are&colon.
:dl compact break=none.
:dt.HIDE
:dd.Object views will be hidden.
:dt.VIEWER
:dd.Object views will be minimized to the Minimized Window Viewer.
:dt.DESKTOP
:dd.Object views will be minimized to the desktop.
:edl.

:dt.NOCOPY
:dd.Controls whether the object can be copied.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object cannot be copied.
:dt.NO
:dd.The object can be copied (this is the default).
:edl.

:dt.NODELETE
:dd.Controls whether the object can be deleted.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object cannot be deleted.
:dt.NO
:dd.The object can be deleted (this is the default).
:edl.

:dt.NODRAG
:dd.Controls whether the object can be dragged.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object cannot be dragged.
:dt.NO
:dd.The object can be dragged (this is the default).
:edl.

:dt.NODROP
:dd.Controls whether the object allows other objects to be dropped
on it.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.Other objects may not be dropped on the object.
:dt.NO
:dd.Other objects may be dropped on the object (this is the default).
:edl.

:dt.NOLINK
:dd.This is an alternate form of the NOSHADOW property (see below).

:dt.NOMOVE
:dd.Controls whether the object can be moved.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object cannot be moved.
:dt.NO
:dd.The object can be moved (this is the default).
:edl.

:dt.NOPRINT
:dd.Controls whether the object can be printed.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object cannot be printed.
:dt.NO
:dd.The object can be printed (this is the default).
:edl.

:dt.NORENAME
:dd.Controls whether the object can be renamed.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object cannot be renamed.
:dt.NO
:dd.The object can be renamed (this is the default).
:edl.

:dt.NOSETTINGS
:dd.Controls whether the object's properties notebook can be opened.  Allowable
values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object's properties cannot be opened.
:dt.NO
:dd.The object's properties can be opened (this is the default).
:edl.

:dt.NOSHADOW
:dd.Controls whether shadows of the object can be created.  Allowable values
are&colon.
:dl compact break=none.
:dt.YES
:dd.Shadows of the object cannot be created.
:dt.NO
:dd.Shadows of the object can be created (this is the default).
:edl.

:dt.NOTVISIBLE
:dd.Controls whether or not the object's icon is visible within its parent
folder.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object is not visible.
:dt.NO
:dd.The object is visible (this is the default).
:edl.

:dt.OBJECTID
:dd.Sets the object's WPS object ID.  This acts as a persistent identifier for
the object, which may then be used as the :hp1.name:ehp1. parameter in
subsequent calls to :link reftype=hd refid=syssetobjectdata.SysSetObjectData:elink.
(or to other functions that accept an object ID as an argument).  The value is
specified as a unique string that begins with '&lt.' and ends with '&gt.'.

:dt.OPEN
:dd.Opens a view of the object.  This may be the ID (0-9) of a user-defined
view, or any of the following values&colon.
:dl compact break=none.
:dt.SETTINGS
:dd.Open the object's settings dialog.
:dt.DEFAULT
:dd.Open the object's default view (as defined by its WPS object class).
:dt.ICON
:dd.Open the object in icon view (folders only).
:dt.RUNNING
:dd.Execute a program object or executable.
:dt.HELP
:dd.Open the object's default help panel.
:dt.PALETTE
:dd.Open a palette object.
:dt.PROMPTDLG
:dd.Open a prompt dialog object.
:edl.

:dt.TEMPLATE
:dd.Sets the object's template property.  Allowable values are&colon.
:dl compact break=none.
:dt.YES
:dd.The object is a template.
:dt.NO
:dd.The object is not a template (this is the default).
:edl.

:dt.TITLE
:dd.Sets the title string of the object's icon.
:edl.


:fn id=wpmenuid.
:p.Some common context menu IDs are listed below.  (Note that not all of
these to every type of object.)
:dl compact break=none tsize=6.
:dt.1
:dd.Open in default view
:dt.2
:dd.Help
:dt.3
:dd.Print
:dt.4
:dd.Select
:dt.5
:dd.Sort
:dt.8
:dd.Find
:dt.101
:dd.Create another
:dt.107
:dd.Move
:dt.108
:dd.Copy
:dt.109
:dd.Delete
:dt.112
:dd.Properties
:dt.114
:dd.Select all
:dt.115
:dd.Deselect all
:dt.120
:dd.Close
:dt.123
:dd.Open in tree view
:dt.303
:dd.Open in icon view
:dt.304
:dd.Open in details view
:dt.309
:dd.Arrange
:dt.316
:dd.Create shadow
:dt.317
:dd.Open in palette view
:dt.503
:dd.Refresh
:dt.704
:dd.Initiate shutdown
:dt.705
:dd.Activate lockup
:dt.708
:dd.Log in
:dt.709
:dd.Log out
:dt.713
:dd.System setup
:dt.714
:dd.Open parent
:edl.
:p.Other standard values may be found in the header file :hp2.wpobject.h:ehp2.,
provided as part of the IBM Developer's Toolkit.
:efn.

.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=wpfolder.Setup string keys supported by folder objects
:p.Folder objects support the following keynames (defined by the WPFolder class)&colon.

:dl tsize=20 break=fit.
:dt.ALWAYSSORT
:dd.Controls whether the current sort order is always maintained. Allowable values are&colon.
:dl compact.
:dt.YES
:dd.Sort order is always maintained.
:dt.NO
:dd.Sort order is not maintained. This is the default value.
:edl.
:dt.BACKGROUND
:dd.Sets the folder background. The value takes the format
&osq.:hp1.filename:ehp1.,:hp1.mode:ehp1.,:hp1.factor:ehp1.,:hp1.type:ehp1.,:hp1.colour:ehp1.&csq.
:dl compact.
:dt.:hp1.filename:ehp1.
:dd.This specifies the filename of the image to use, or '(none)' for no image
(i.e. color only). You can use '?&colon.' to specify the boot drive.
:dt.:hp1.mode:ehp1.
:dd.Specifies the display mode of the image.  This parameter may be omitted
if :hp1.filename:ehp1. is '(none)'.  Allowable values are&colon.
:dl compact tsize=4.
:dt.N
:dd.Normal&colon. the image is displayed as-is, centred within the folder.
:dt.T
:dd.Tiled&colon. the image is displayed multiple times in order to fill the
entire folder area.
:dt.S
:dd.Scaled&colon. The image is scaled to fill the entire folder area, according
to the specified scaling factor (below).
:edl.
:dt.:hp1.factor:ehp1.
:dd.This is an integer value which sets the scaling factor when :hp1.mode:ehp1. is S (scaled).
:dt.:hp1.type:ehp1.
:dd.Specifies the background type&colon.
:dl compact tsize=4.
:dt.I
:dd.Image background
:dt.C
:dd.Colour only (no image)
:edl.
:dt.:hp1.colour:ehp1.
:dd.RGB value of the background colour to use.  This is specified as three
space-separated decimal byte values, representing red, green, and blue,
respectively.
:edl.
:p.Examples:
:xmp.BACKGROUND=(none),,,C,128 128 128
BACKGROUND=?&colon.\OS2\BITMAP\TXTR_000.BMP,T
:exmp.
:dt.DEFAULTVIEW
:dd.Sets the default view. Allowable values are&colon.
:dl compact.
:dt.ICON
:dd.Icon view
:dt.TREE
:dd.Tree view
:dt.DETAILS
:dd.Details view
:edl.
:p.The default behaviour is to use the default view of the parent folder.
:dt.DETAILSCLASS
:dd.The name of the highest-level object class for which details are displayed
when in details view. The default is 'WPFileSystem'.
:dt.DETAILSFONT
:dd.Sets the font used in details view.  This value is specified as
':hp1.size:ehp1..:hp1.facename:ehp1.'.
:dt.DETAILSVIEW
:dd.Sets the view style for details view.  Allowable values are&colon.
:dl compact.
:dt.MINI
:dd.Display small icons. This is the default.
:dt.NORMAL
:dd.Display normal sized icons.
:edl.
:dt.ICONFONT
:dd.Sets the font used in icon view. This value is specified as
':hp1.size:ehp1..:hp1.facename:ehp1.'.
:dt.ICONNFILE
:dd.Sets the animation (open folder) icon from an icon file.  This value is
specified as &osq.1,:hp1.filename:ehp1.&csq..
:dt.ICONNRESOURCE
:dd.Sets the animation (open folder) icon from an icon resource in a
dynamic link library (DLL).  This value is specified
as &osq.1,:hp1.resource-id:ehp1.,:hp1.module-name:ehp1.&csq..
:dt.ICONVIEW
:dd.Sets the view style for icon view.  Multiple options are separated with
commas; mutually-exclusive options should not be specified.  The default view
is 'NONGRID,NORMAL'.
The allowable values are&colon.
:dl compact.
:dt.INVISIBLE
:dd.Do not display icons.  Mutually exclusive with 'MINI' and 'NORMAL'.
:dt.MINI
:dd.Display small icons.  Mutually exclusive with 'INVISIBLE' and
'NORMAL'.
:dt.NORMAL
:dd.Display normal sized icons.  Mutually exclusive with 'INVISIBLE' and 'MINI'.
:dt.FLOWED
:dd.Display the icons in multiple columns.  Mutually exclusive with 'NONFLOWED'.
:dt.NONFLOWED
:dd.Display the icons in a single column.  Mutually exclusive with 'FLOWED'.
:dt.GRIDDED
:dd.Display the icons in a grid.  Mutually exclusive with 'NONGRID'.
:dt.NONGRID
:dd.Display the icons in standard arrangement (left to right
best-fit).  Mutually exclusive with 'GRIDDED'.
:edl.
:dt.ICONVIEWPOS
:dd.Sets the initial icon view position and size of the folder on the
screen.  This value is specified as &osq.:hp1.x:ehp1.,:hp1.y:ehp1.,:hp1.cx:ehp1.,:hp1.cy:ehp1.&csq.,
where :hp1.x:ehp1.,:hp1.y:ehp1. represent the coordinate of the lower left
corner, and :hp1.cx:ehp1.,:hp1.cy:ehp1. are the width and height of the folder,
respectively.  All four values represent percentages (0-100) of the screen size.
:dt.OPEN
:dd.This causes the folder to be opened in the specified view.  The allowable
values are&colon.
:dl compact.
:dt.ICON
:dd.Open in icon view.
:dt.TREE
:dd.Open in tree view.
:dt.DETAILS
:dd.Open in details view.
:edl.
:p.The default behaviour is not to open the folder.
:dt.REMOVEFONTS
:dd.This deternmines if instance fonts are removed.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.Remove all instance fonts from the folder.
:dt.NO
:dd.Do not remove instance fonts from the folder.  This is the default.
:edl.
:dt.SORTCLASS
:dd.Sets the name of the object class by which folder contents will be sorted.  The
default is 'WPFileSystem'.
:dt.TREEFONT
:dd.Sets the font used in tree view.  This value is specified as
':hp1.size:ehp1..:hp1.facename:ehp1.'.
:dt.TREEVIEW
:dd.Sets the view style for tree view.  Multiple options are separated with
commas; mutually-exclusive options should not be specified.  The default view
is 'LINES,NORMAL'.
The allowable values are&colon.
:dl compact.
:dt.INVISIBLE
:dd.Do not display icons.  Mutually exclusive with 'MINI' and 'NORMAL'.
:dt.MINI
:dd.Display small icons.  Mutually exclusive with 'INVISIBLE' and
'NORMAL'.
:dt.NORMAL
:dd.Display normal sized icons.  Mutually exclusive with 'INVISIBLE' and 'MINI'.
:dt.LINES
:dd.Display tree lines.  Mutually exclusive with 'NOLINES'.
:dt.NOLINES
:dd.Do not display tree lines.  Mutually exclusive with 'LINES'.
:edl.
:dt.WORKAREA
:dd.Indicates whether the folder is a workarea.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.The folder is a workarea.
:dt.NO
:dd.The folder is not a workarea. This is the default.
:edl.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=wpprogram.Setup string keys supported by program objects
:p.Program objects support the following keynames (defined by the WPProgram class)&colon.

:dl tsize=20 break=fit.
:dt.ASSOCFILTER
:dd.The filename filter(s) for files associated with this program.  Multiple
filters are separated by commas.
:dt.ASSOCTYPE
:dd.The file type(s) associated with this program.  (File type is determined
by the .TYPE extended attribute.)  Multiple types are separated by commas.
:dt.EXENAME
:dd.The filename of the executable program.
:dt.MAXIMIZED
:dd.Indicates whether the program will run in a maximized command-prompt
window.  This setting only applies to text-mode programs.  Allowable values
are&colon.
:dl compact.
:dt.YES
:dd.The program window is maximized upon startup.
:dt.NO
:dd.The program window is not started in a maximized state upon startup. This is the default setting.
:edl.
:dt.MINIMIZED
:dd.Indicates whether the program will run in a minimized command-prompt
window.  This setting only applies to text-mode programs.  Allowable values
are&colon.
:dl compact.
:dt.YES
:dd.The program window is minimized upon startup.
:dt.NO
:dd.The program window is not started in a minimized state upon startup. This is the default setting.
:edl.
:dt.PROGTYPE
:dd.Indicates the session type for the program. Allowable values are&colon.
:dl compact tsize=36 break=fit.
:dt.DOSMODE
:dd.Run the program in standalone DOS mode.
:dt.FULLSCREEN
:dd.Run the program in a OS/2 fullscreen session.
:dt.PM
:dd.Run the program in a Presentation Manager (PM) session.
:dt.PROG_30_STD
:dd.Run the program in a Windows 3.0 standard compatibility, fullscreen session.
:dt.PROG_31_ENH
:dd.Run the program in a Windows 3.1 enhanced compatibility, fullscreen session.
:dt.PROG_31_ENHSEAMLESSCOMMON
:dd.Run the program in a Windows 3.1 enhanced compatibility, window, common session.
:dt.PROG_31_ENHSEAMLESSVDM
:dd.Run the program in a Windows 3.1 enhanced compatibility, window, separate session.
:dt.PROG_31_STD
:dd.Run the program in a Windows 3.1 standard compatibility, fullscreen session.
:dt.PROG_31_STDSEAMLESSCOMMON
:dd.Run the program in a Windows 3.1 standard compatibility, window, common session.
:dt.PROG_31_STDSEAMLESSVDM
:dd.Run the program in a Windows 3.1 standard compatibility, window, separate session.
:dt.SEPARATEWIN
:dd.Run the program in a Win-OS/2 windowed session under a separate virtual DOS session.
:dt.VDM
:dd.Run the program in a DOS full-screen session.
:dt.WIN
:dd.Run the program in a Win-OS/2 full-screen session.
:dt.WINDOWABLEVIO
:dd.Run the program in an OS/2 windowed session.
:dt.WINDOWEDVDM
:dd.Run the program in a DOS windowed session.
:dt.WINDOWEDWIN
:dd.Run the program in a Win-OS/2 windowed session.
:edl.
:dt.NOAUTOCLOSE
:dd.Determines the disposition of the window after program termination.  Allowable
values are&colon.
:dl compact.
:dt.YES
:dd.Leave the window open when the program terminates.
:dt.NO
:dd.Close the window when the program terminates.  This is the default.
:edl.
:dt.PARAMETERS
:dd.The parameters that will be passed to the program.  This may include
substitution characters.
:dt.SET
:dd.Specifies DOS environment variables for DOS or Win16 sessions.  The format
is &osq.:hp1.variable:ehp1.=:hp1.value:ehp1.&csq..  Each variable/value pair
must be separated by a null byte ('00'x); the entire string must be terminated
by two consecutive null bytes.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=wpprogramfile.Setup string keys supported by executable file objects
:p.All executable files are represented in the Workplace Shell by the
WPProgramFile object class.  These objects are different from program objects
(WPProgram) in that they represent the actual file on disk.

:p.WPProgramFile objects support the following keynames&colon.
:dl tsize=20.
:dt.ASSOCFILTER
:dd.The filename filter(s) for files associated with this program.  Multiple
filters are separated by commas.
:dt.ASSOCTYPE
:dd.The file type(s) associated with this program.  (File type is determined
by the .TYPE extended attribute.)  Multiple types are separated by commas.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=wpshadow.Setup string keys supported by shadow objects
:p.Shadow objects support the following keynames (defined by the WPShadow class)&colon.

:dl tsize=20.
:dt.SHADOWID
:dd.This specifies the object or file for which this object is a shadow. This
can be specified as either an OBJECTID, or a fully-qualified pathname to a
directory or file.
:edl.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100% id=wpprinter.Setup string keys supported by printer objects
:p.Printer objects support the following keynames (defined by the WPPrinter class)&colon.

:dl tsize=20 break=fit.
:dt.APPDEFAULT
:dd.Indicates whether the printer object is set as the default printer.  The
allowable values are&colon.
:dl compact.
:dt.YES
:dd.This printer is the default printer.
:dt.NO
:dd.This printer is not the default printer.
:edl.
:dt.DEFAULTVIEW
:dd.Sets the default view for the printer. The allowable values are&colon.
:dl compact.
:dt.DETAILS
:dd.Use details view as the default view.
:dt.ICON
:dd.Use icon view as the default view.
:edl.
:dt.JOBDIALOGBEFOREPRINT
:dd.Indicates whether a job properties dialog will be displayed before printing
each job.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.Display the job properties dialog before printing.
:dt.NO
:dd.Do not display the job properties dialog before printing.
:edl.
:dt.JOBPROPERTIES
:dd.Specifies the name of a binary file containing the default job
properties.  (The contents of this file correspond to the
:hp2.PRQINFO3->pDriverData:ehp2. structure, which is defined by the Presentation
Manager spooler API; refer to the
:li.:link reftype=launch object='view.exe' data='PM1.INF+PM2.INF+PM3.INF+PM4.INF+PM5.INF DRIVDATA'.Presentation
Manager Programming Guide and Reference:elink. for more information.)
:dt.OUTPUTTOFILE
:dd.Determines whether the printer output will be directed to a file.  The
allowable values are&colon.
:dl compact.
:dt.YES
:dd.Direct the output to a file. The user will be prompted for a filename for
each job.
:dt.NO
:dd.Do not direct the output to a file.
:edl.
:dt.PORTNAME
:dd.Indicates the name(s) of the printer output port(s).  Multiple port names
may be specified by separating them with commas.  The ports must be installed
already.
:dt.PRINTDRIVER
:dd.Indicates the complete name of the installed printer driver used by the
printer.  The format is &osq.:hp1.driver.device:ehp1.&csq. (e.g.
&osq.OMNI.HP Deskjet 500C&csq.).  Multiple driver names may be specified by
separating them with commas.  The printer drivers must be installed already.
:dt.PRINTERSPECIFICFORMAT
:dd.Indicates whether print jobs are to be spooled in printer-specific
format.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.Jobs are spooled in PM_Q_RAW (printer-specific) format.
:dt.NO
:dd.Jobs are spooled in PM_Q_STANDARD format.
:edl.
:dt.PRINTWHILESPOOLING
:dd.Determines if printing is allowed while jobs are spooling.  The allowable
values are&colon.
:dl compact.
:dt.YES
:dd.Printing is allowed while jobs are spooling.
:dt.NO
:dd.Printing is disabled while jobs are spooling.
:edl.
:dt.PRIORITY
:dd.Indicates the priority of the printer queue associated with the
printer.  This is a number from 0 to 9, where 0 is the highest priority and 9
is the lowest.
:dt.QSTARTTIME
:dd.Indicates the time when the printer starts printing.  The format
is&colon. &osq.:hp1.HH:ehp1.&colon.:hp1.MM:ehp1.&csq. in 24-hour notation.
:dt.QSTOPTIME
:dd.Indicates the time when the printer is to stop printing.  The format
is&colon. &osq.:hp1.HH:ehp1.&colon.:hp1.MM:ehp1. in 24-hour notation.
:dt.QUEUENAME
:dd.Sets the local queue name for the printer.  This will be ignored if the
printer object has already been assigned a queue.  If omitted, a queue name
will be created for ths printer automatically.
:dt.QUEUEDRIVER
:dd.The name of queue driver to use.  The driver must be installed already.
:dt.SEPARATORFILE
:dd.Indicates the name of a file which will be printed before each print job.
:dt.SYNCJOBPROP
:dd.Indicates whether the default job properties will be synchronized with those
on the network.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.Job properties will be synchronized.
:dt.NO
:dd.Job properties will not be synchronized.
:edl.
:dt.SYNCPRINTERPROP
:dd.Indicates whether the printer object properties will be synchronized with
those on the network.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.Printer properties will be synchronized.
:dt.NO
:dd.Printer properties will not be synchronized.
:edl.
:dt.TAKEDEFAULTS
:dd.Indicates whether or not the printer object will be created with default
settings.  The allowable values are&colon.
:dl compact.
:dt.YES
:dd.The printer object will be created automatically using default values for
its settings.
:dt.NO
:dd.The &osq.Create a Printer&csq. dialog will be displayed when the printer
object is created.
:edl.
:edl.


.******************************************************************************
:h1 x=left y=bottom width=100% height=100%.Notices
:p.:hp2.REXX Utilities API Documentation v1.2:ehp2.
.br
(C) 2009 Alexander Taylor

:p.This document may be freely distributed, so long as it remains in its
original format and retains this copyright notice and list of trademarks.

:p.:hp1.IBM:ehp1., :hp1.OS/2:ehp1., :hp1.AIX:ehp1., :hp1.REXX:ehp1., :hp1.Object
REXX:ehp1., :hp1.Presentation Manager:ehp1. and :hp1.Workplace Shell:ehp1. are
trademarks of the International Business Machines Corporation in the United
States and other countries.

:p.:hp1.Windows:ehp1., :hp1.Windows 95:ehp1., :hp1.Windows 98:ehp1., :hp1.Windows
NT:ehp1., and :hp1.Windows 2000:ehp1. are trademarks of Microsoft Corporation in
the United States and other countries.

:p.:hp1.Linux:ehp1. is a trademark of Linus Torvalds.

:p.Other product and company names referred to may be trademarks of other
parties.

:euserdoc.
